<a class="logo" href="<?= Yii::$app->homeUrl ?>">
    <span class="logo-mini">
        <img src="data:image/png;base64,data:image/png;base64,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" />
        
    </span>
    <span class="logo-lg">
        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAncAAACmCAYAAAC4N6nBAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAuIwAALiMBeKU/dgAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAACAASURBVHic7N13eFRV+gfw73tmUpAmNZOAJEFsBAuZoKvgT5oitl0hA2JZeyFgXSsqjnXFLiUIdhFRhoBrBSXAunaT4CpYKQGRJDTpaXPP+/sj4EIySWbuuTN3ZnI+z4OPZO4952WS3Dn33HPelxBneg8bkwUHBhD4WAIdy+DuANqBkAxGmwMOZQDbG22IIUHY0cirfwT4WhWBKv93OleDsQIwXlv5oe+HYON3uXM/AXAigL37vmQA2Pm/I2g7wFz3v7SHJGoAgImrDzinkomriMkPYFddPNhBgGRgL4j2EvNOAezwC+yGwbvJgd1JVUl/rO+0cReWLfMHG6+maZqmadGF7A7ACkefeUGGg+gqEI8EcLTd8dRjgHD3yvffnBTMwSnukScR6AvY+70pB9EvYLkSRO92qqTClSt9NTbGo2mapmlakGJ6cHfMWRemC5J3g3EZgAS742kKE/7vh/ff/E8wx7pyRr4JptHhjilYDGwXhHxHAj254QvfNrvj0TRN0zStccLuAEyirLMvuEZA/gDG1YjygR0AEOMJBDmYZsIEAFEzU0bAocyY4K/hNS63Zyxi/KZA0zRN0+JZzH1I9zlvTArXyldBNMzuWELFxKN+eP8tXzDHpmTnPkWEm8MdkymMdxJrEy9b//0bgdYeapqmaZpmo5iaucs619OD/fyfWBzYAQAxTeo1fHhSMMcm1SY+CCA6H4ESzqtJrPm020kjutsdiqZpmqZpB4uZwV2f4aMPh+H4BMARdseiIDOZ2l0XzIH7ZsUeCXM8KnobfvFJ9+M93ewORNM0TdO0/4mJwd2xZ1/YgQUtBJBudyyqGHRf1jBPx2CO7VRFUwBeHe6YFGT6nVjYwe1pb3cgmqZpmqbVif7BndcrGMbrYPSyOxSLdIDDeVswB65c6athwr3hDkgN90kizEIMrt/UNE3TtHjksDuA5mS1dt0PpqvsjsNi7pTMPq9tWr1iZ3MH7tn448o23XqfAeCwCMRl1lGt047Ztqfsx6/sDkTTNE3TWrqonrnrPWxMFhh32h1HGLRiJz0U5LEMorvCGo0FCPRYSs75feyOQ9M0TdNauugd3Hm9ghw8AzGQw84cvviYc0dnB3Nk+Te+f4PxTrgjUpRE7HgB8Ebvz5SmaZqmtQBR+0Hc56ufLgPQ3+44wkgIgx4N+mDiOwBEe83Xk1Kzv7/S7iA0TdM0rSWLyjV3J3s8raprxXwA7eyOJcwO73pk7y83/7qy2R2xu8p+3NImrXcagJwIxGUe0V8S0rJmVpX9UG13KJqmaZrWEkXlzN2uveIWAC0jQS6LxzweT1CDbK417gPQ7CYMm3VJAkf9GkFN0zRNi1dRN3N35LljOguJtwAk2x1LhKRsrhVrN/+64tvmDtxT8dOetmm9nQAGRyAuFSe2Ss16c2/ZD9FZYUPTNE3T4ljUzdwlGLgHQEtLivuQ+9xzDwnmQEciPQnwb+EOSFGig/hhu4PQNE3TtJYoqmbujj7zggxBeAWA0+5YIqxdLSft2fzrik+bO3Dnhh/8rbv13kGgv0YiMAVZ7dKyCneV/bDe7kA0TdM0rSWJqpk7h8DDAJLsjsMOBNzV57wxKcEcW1F07CsAloc3InUS/CR05QpN0zRNi6ioGdz1Hn5BXwAX2B2HfbgtauXdwR3rlcQxsWnhxNTs3AvtDkLTNE3TWpKoGdwRYRKiKB47MNF1WcM8QdXQLSspWMTAR+GOSRUTHk1zB7eeUNM0TdM0dVExmOozfPQZAE63O44okADhfDDYg5n5NgAyjPFYoTtT8s12B6FpmqZpLUU0DO4IoH/aHUTUIB59zPDRfwnm0E0lBd8B/Fq4Q1LFzHd2do9ItTsOTdM0TWsJbB/c9R4++kImBFVjtYUgQcGXJXP6xT0A9oYxHiu0SYB4wO4gNE3TNK0lsDUVSq/hw5OclFwAoIOdcUShjK5HHPvV5l9XrGruwJ0VP+xq2613awCnRiAuFSe0Tc16f3fZD2V2B6JpmqZp8czWmbskajcOQKadMUQvngSvN6jvT21SzaMAKsIckCrBhMftDkLTNE3T4p1tM3cn/O2yQ6Xf8IGgd1IGlpLy+5bVm35d8V1zB+797eeaNqnHVILorEgEpiCzdeoxJXvKfvzF7kA0TdM0LV7ZNnNXW1N5Fwid7Oo/FjDwYMbAy4KqsVvebusMAD+EOSRlRPQ43Nck2B2HpmmapsUrWwZ3x5/j6QbQeDv6jjHph7SqHhfUkcuW+YnpnjDHY4WjUrDtOruD0DRN07R4Zcvgzi+djwD6cWwwiPjurGGejsEcW1biW8Cgz8IdkyoCJnZwe9rbHYemaZqmxaOID+76nDnmOIAvjnS/MawDhOP2YA92AHeGMxiLdE6GjIU4NU3TNC3mRHxwx4Ift6PfmEa4sc8ZFxwWzKEbi32fgujdcIekikE3pbk9PeyOQ9M0TdPiTUQHWVlnjxoE4IxI9hknkmUCvMEeLFjeDsAfvnAskSzBQZda0zRN0zQtOJEb3Hm9gqR4ImL9xRliXHrM2aP7BHPsxuKCn8CI+rJkAC5Ozfa47Q5C0zRN0+JJxAZ3WV/9eLEuM6bEITj4GrxOgyYi+suSCSbWA35N0zRNs1BEkhhnDLwsOTHRKABwaCT6i2NHdj2y9yebf11Z2tyBOyt+2NUmtXd7EPpHIC4VGW269f5698Yfmi21pmmapmla8yIyc9e6VfUNANIj0VfcY/EoAArm0GTp/yeAbeENyALMT2LgQKfdYWiapmlaPIjMB6pggsQk0+cTJYO5VdPHoBaM3ab7qE+gBsAey9pTQBIOBtrt//vx53jS/vue7/fmziv99u3tKdmePAg5OLwRqnPt6XRUObDS7jg0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0TdM0LS4FVcaqOWfeOLqfYL4XhJPASACQCKC1FW2bRcBuBtY7qir7vTvz3b3h6KPjSRe1SzSqs0nyESxwBJgyQdQVzJ0BdAaQAKA9IlTmLQxqQLSozfbdnlWrPqwOTxdekeJemUUsj2FQLxLoBSAVjC4AugBoCyAJwCHh6d+UXQD8AP4AsBnAFib+naRYRcAq4RQrf//6rV8BcKQDS832nA/iSQz0RIRqR0fYXtS9/xUAbQDkT2BaIQR9vrHI93M4O+524vmdDL9zBohPxwEVY+KIBLADwFYA5WBeC0ErJGi5k6s+21gcnutoLOnsHpHqhLgIhDPB6IO6a1Rj13eJuvKPqwF8zRL/qljeZynglZGK1yopObl/JcYkAIcjUpWtwmMHAAnwNhBtgsRmEP/OED8Llj8RiR83FvvW2xVcmnvk0QZoDgHHIrTr9xoQriwvmrds/xeUB3dn3zBqEAOLUDeQiSoEXPb+5LmvWtag+5qErvTHQAH+KxinAshCfH6AHoSZLqgo8b1lVXvdThx9pN+QIwR4MAMnIT4/KLcC+JIYi1k63y7/9s3ScHfYpZ/H5ZC8BkDTpfri13oCLzCkfHnT8gX/tbpxlzt3OoDrrG43RlQz8G/BPIuoZn6LG+gNHOh07e58Dxi3QelGk1ZIwi2binwfWxZbmKUcd35XSnCsgc0TNhG0Yd/P+r+Zxdvly32bI9WxK3vkayC6xMy5xPi8rGRe/z//rhKIx+tJ3LONvgdwpEo74cCMLz6cMrc/LJg9cZ1wQQY5am9i0CUAOqpHF1uI+JayooKnVdrofrKnlVHLf2em8QD3sSq2mMH0DQRP7VRJb65c6asJRxeunNzhYHwQjrZjDQMfCcl3ly0vKLKqTZc79zvU3VG3dJsJ9GhS29b5pcteqbI7mHBLc597CHPyv5h4qEVNSoDuLy/2PWBRe2HVNcdzumD+yO44bOIHqJCJX6nIJB98PiOcnbncuYUATNaC59Ly4oLM/X9Tely4dxtuQxQO7ABIB/gmKA7sXH09XVzZuS/C4f+VQTeiBQ7sAAAszN8EeDwOV45nvL+G1zHjuRY5sAMA4n5gvLo1mdem5Iy8AvBa/qiewYda3WasIuAMFvSVK2fkY716DU+yqNn2FrUT67ow+MmqXbuL0nJG9rU7mLAaONApOWmehQM7ABAA3+9y595rYZthI7hFX1ecAA8jxhzXGvlzavbIq+HxxMTTOtMfMMOvH9GdQXdZGYxViPHie1N8X6u0kZrjuQSCfwbhCsT2GgPbpOSc3ydlDReBeQrq1qZoQBoxvehyr/ysywkjj7A7mDgnwHTb7kNbv9+5/3lt7Q4mDmVJpk9dOSPPsjuQcEnZ2ckLwvAwNX9/Sk7uX8PUtmY5OpyJZrrW8pexcFNjenBH5HwK0fkM/g8Jvtv02R6PIyUn92lmfg1AB+vCallSc0aOJHZ8QcAJdscSnfgvwkFfu3Jyw/XBoe3HGOKsTHw3K8uTaHcocegQML2dku0x+SgpeqW5PQOIwjqBQcR4uXPfC9LC2IdmNUaOZPralT1ynN2hNMXU4O7s6y84FUCuxbFYg+H9cIrZBZBe4VrDLxHjJmuDallSs0dezExzAbSxO5ZoRsChYLyTmu053+5Y4h7htK2t+Cm7w4hTCUTsS3N7etgdiGUGDnRKYDrCn+mgg1P4ldYza7Zwgmhq3SYr65fYWCHkoAZ6BzpZyGmwKI2KxX6oqD50utmTU3JWPAng7xbG0+KkZI88l4leRuymf4k0JxPPcblHDLI7kLjHyHPl5A60O4w41VEyP2d3EFZJ3dk5khu/RnXN8Zweob40a13nyv7+WbuDCCTkD+BD/uh6PTg6d4wx083FM2fWmjk3Jcdznp6xU9PtpBHdiegV6DWKoUoCxOtp7jGd7Q4kzhEYTyE6b0xjH2F4arbnTLvDUNXj2As7MCGimx0E8xOxslBfq4dovMude4fdYdQX0uDuvBvHpIAxMVzBKPJ9OOUtU9u1exx7YQdift7qgFoav1+8iJa6o1hdmuTaKXYH0QL0TckeeY7dQcQvjokdoE2pSayZgMhfx45LWSsvjXCfmnUedPUb0c/uIA4U0uCulo1JAKJxW3SlFOJ2syfXJtbcBqCrhfG0OGnu3DMIOMPuOGIaYXRqtsdtdxjxjoiusTuGeMWEU1Jyzo/ZdEeuEy7IADDejr6J6cGU4y6Jxk2KWvMSIMWsaNq0FfTg7pybPCdTlK5HY+CfC58xVwHA1dfThYEbLA4pvpBsNl+gZHooEqHEOWLi++0OogU4Uz8CDx/B4iK7YzCLHf6HACTb1H0aJVT9w6a+NXVHbU2SV9sdxH5BDe68Xq+Qkp5BdK5VWe+sqnzS7MlEfBGiM6VL1GCmDU29nuYekQ3iqJqSjmHD0/pdcJjdQcQ5p8H+IXYHEa8YNMzuGMxIzfa4CRhjbxR8W2f3iFR7Y9BMI7onzX1uVNRBD2rh+1d//HAlASeGOxgzBPimd2ear3MoCZdG44g1ShggfNxm+553mjpIQlwWxhjWA9gMYAdAVQDvCWNfzaB2YE4GoQ2AwxCeR/nCMPyXAHgkDG03pRyEGWBURrjf5nRgxqEk6Bgwu2HRjRgRDwRgWb3kIMwFUBLB/ppHaMUS7YjQDUA/AJnNnRKk43sce2GH9d+/8YdF7UUEEx6H+i7/PVD7GW2TAPEAgKiZAVIkAfoY4J02x9EKoNYAtwP4UIDSEZ6Nfy6JRA8A62ram9TsP+68289r669CVNbAI3Dhe5N9C8yeX7e+wm9lkl0/AUsZKCGilVIavxI7drJTViVVJcXUhQ4AEiv/2Ltq1YfVQRxqXZ42QhEYbzL401pn8o/bvppt90WhUd1OPL+Twc4+MHggES5iwJKKE0Q4DxEe3BHR1LIi38OR7DNUWVmexG1J7GHCPQCOVmuNIplce1d58bwLYEGd63BKzR59jCTjZgKugtpTGlGTXHscgH9bFFrYudyeswFWSkfExBdWFBXMSe074v9YiMUAEky1A1yeknP+sxVFC1aoxBMVmGeXl8yLuuVcGQMvS67esauPdIjjiXkYgLMBWDPjRuIKxMLgzl/d6l6AXZEIJkR+QCilLmGnMYSsudz+AWCSH/K1LcXzyyxpMUak5XiOkszdLWhqHTFdV1bsW2hBWxHx+9cLtqLuA+zfgPdBl/v7SwB6GuqVTdwdT7qoXSQHtswc9QXgV6701QCY3SXL8y9HMr+JuguySRGtcVyFKB/YAUBZyVs/ArgmJSf3fWLMBWB+cbgh+yBWBncejwNreJJSG4wPK4oL5gBA2fL5n7hycmeCYbaCgYPgeBwIW9mziCFqekmPXUqXvVIFoGjfnxe7nXh+J79f3ExEtwJQq0XNfGqa29NjY7FvvQWhmtbkFPTZN4/sCeao3GxAjGffn/yW2p0Nq92p7bPcL519yovnTWppAzsAkAwLyg7RCq41TiwriZ2BXUNeWV5c8KoAnwKgQrExZ1JtzSlWRBWPNq/07a5xJl0IYI1CM20yTvhbNO78t11F0bx/gekelTaIYMUNX0SkrpZXAMhSaEJK8J0HfoFrjAcA7DLdIuNMndg4cn7/esHWipKCexjUD+BSxebIINj+vWtycCcNxxNQHcWGR0V1NT+o2ggBxyk2sR6Shm1Z/uZG1VhiFTMfr9jEHnbgvIrvFmyyJCCbbSwu+AkE5UdwLFj1ZzOubftq9k4G/qnSRrVI0gvXG9GpGs8CKDd7PoNi4r1NOe6S1kyktkOdefamkoLvDvxSxXcLNhHwmEqzDsbj0VraKl5VFPu+J8kDAShN1JDkodZEZF6jPzjn3HTBQLJyLZWVmO9cPNO3Q6mNgQOdAI5UCoNwQ/lys3Vs4wOR0h0vAEyt+Nq31pJgokR50bxlAAqUGmH0tiSYOOZA9RsAglkTGpAkfzsLw4kr+x+Bmz2fgZh4b/elHlEZiFYTB07cTKh+CoDpG38GH+/KXqETG0dY2fL564j5cqVGCLY/eQk4uKtLfSKfiHQwQSEuOrFT1muqzXTZ3ikTarOS6yuK+ryrGkccUFrYLsCvWBRHdBE0Vel8UrvxaAk2Fr+7F8B/zZ5PRK0sDCfuEONzhXPtyhUXtC79PC6Ab1NrhaeVLZ+/LtArG4vf3cvAfUqtEx6MltQaLUlZScEiMD5UaOIwu5d9BBzcfb3txysARGOmfCkkxnm9XqnakJNY6bEBM88C1OOIZb16DU8C0EmhieKNxQU/WRVPNCnPwKcAtplugNV+PluQH82eKEGmdjO2FMxk/ndTKGzGiBBhsBdAG7PnM7Dd4ZBN7mqv6EkvA1hptg8Cukkk6cTGNiDQZJXTq4XzWMuCMaHB4O68289rC3BUpj4B6OX3pvi+tqIlJlLcASyWWBFHLNvbvk0KFFImMKPIwnCii89nAGR6VgmgFOuCiV8E3m72XCezTnHZBL8wYi59U7BSs0cfQ4QrFZt5bN+O+cb5fAYz7mzymObdXjfLqEVSGXUoZMD09YVBh1sZT6gaDO78Va0mQG0NQrjshF8q7eA6iBBKCWg5wWn6bixesJRqSXzJ/B1tTGCp8u9r1SXLY3pWocUgsjGpdXyTzlZx+94yjEehkMSWgd8dqH42mGMrSua9B2CZ2b4AtBEsdVnCSCueWUsKicdZ8emgqoMGd+eO92QCrJQ7Lnx44gf5PtO7txqQUFlvs2XTV3NU013EPsU1S0wKj31igRA/K53u8Ou1Ns2QkqM+f5wWXVz9PKehLlG4Cu++NZ/BEfJ2KOygJ6YrXf1Gqm5e00JE4O/Nn2vvJNlBgzsp6DHYVzS5KT9UVHXIt7JBIlbZTBEXaTtUSYfSewhBhukp71hAUir9+xwJzmj8XdS0WEYw8LhaE/xjRdstr4RyRvk3878B8VyFTh2QQim1ihY6CTKfS5fRxcJQQvbn4O7MG0f3YyDXzmAaIyFuKJ45s9baNhV2yrJ+FAQAJIXS4I6MhN1WxRKNiKD076s1ZDTmmNS0mJWSkzsaxP1U2hDABCxb5g/1PCZMAFBjvmc+K6XfSNvzp7Ukjrra5qYQKT0dVPbn4I4kW7eezUIEzFs4+c1Cq9sVgMP0yWRn8frowcRKhZfJQXE9uDOE2uDOKZzhKGwdV4jI/LopRqWVscSbNnvZ/DWSEXXl7Hr1Gp5ErFazmRifbywueNvMuRXfFKwh8HSV/iFJJzaOIL8k01VGGGTrkxcBAMNuHplFhHPsDKQRlYYQinmIwoGCX2uhNcovSOEuNvoJP8f1vy9KtDd7osFGxGr3xqIahzT93hIQde/tnkMPyQOQqdIGEd2hdD4SHwJgOgE/ASe4slf+XSUGLXjk8CuUkGP7B3cO6bgbzZQis8mkhc+8WWp3EA3pRdyaFhUIpndsk1OYv3C3BE7D9HsrOboGdz2OvbADK9bLBeOdjcW+T1Wa2Fg8ZwuDHlUKg/ghndg4MoRhfuYOZO+YSgy//qJ2YPzNziAasd5RVam48FXTtLjG5pOtO2RiVA1Aoo7Ce0uCo+q9rUmsmQCgo0ITBpjusiKWhEQ8C/BvZs8noBsj6RYrYtGaVitU1kjaS5CoOQewd+FfIMR087szQ9hqrmlai5KW4zkKQLrJ03duLJ7TdALaFo7Aw0yfzFRqXSRqXCdckAFgvFIjjFfLl/t+sCKeDV/4KsFiolo4uL3rSWN0onOtUYIkDbQ7iPoIXPj+lLfm2x2HpmnRS4KvN3suMVZAIe9YvEs50ZPJML8OW4C+szIeFeSofRhqKb4qHQlSqUZsfeUlWa8BUHmP2lJtrU5srDVKyOirIVsrGTfYHYSmadErze0ZAMZ1Zs9nUvpgjXNeQQZehPmMApxo1JrPD2ah1GyPm0FjFJuZ/PtX8zdYEtCfvJJYcXMG4UpXX09vqyLS4osgQobdQdQz9cMp1kx/a5oWf1JyPOdJ8HtQSGfEQLGFIcWN7id7OrrcK94BeJBCM6tLv307KhKUM+FxKNS/BrAt2fArbYBoTFmJbyEIKmm+nBCsExtrATkBRE/9SsKmRKp5wO4wNE2LIh6Pw1Uqj2ZJJwvG5cx8imKLftQa71gSWxzoduL5nQzpOBGM4f4avgxAW8UmCywIS5nL7TlbcZAKAP8M50BVsLxdQnwD89kqzk7pmzukYvk8y3PBarHNSUANA4l2BwIALHHX21Oi445P01qYu1zu3Dy7g6jHwUB7WsOHAgQCwCpzMPsQsLT8uwWRLCHY0eXOXR3B/oLVBkB7w1Co1hOAgFQps2UNj8eBNTxJsZX1yW3bTLUknkZsLJ5fkuLOnUPARWbbIIHHAW8O4JVWxqbFNicDpQD62B0IgOKTOvV+5UO7o9C0lqnTvj9RxYKxXAMMnh2GZpviANAzwn3a5YeNxfNL7A4idbW8gomy1FrhiaXLXgl7pQ0ynPfA4c+F+ZKYfV3u7y8pL8arVsalxTYB0HK7gwAgBXOe16vvPDRNC6ufy9tujfTgrsUg1UTBFuiS5WnDRKo7Sb8v7yletySgZpR/+2YpgCkqbTDoYZ3YWDuQYMHRkHLk1fem+L62OwhN0+IbM99mpui7Fgz6sqzEZ6ruqpUcrfhWAKlKjRDfCZ/PsCai5iUb/ocBmM67SEA3puSbLQxJi3GizaH8AYBy2yIg7HCSw5LM35qmaY1ivFNRUvCu3WHEqSpBMg825w7s0s/jAuMfSo0w/l1eVPCBRSEFZd+mDbWyZMx36MTG2n7C5/XVgPhZG2O4/51n51TY2L+mafHv+2Tpv9TuIOKUJMZVG4sKbF/iIwz2Qi0DBDOxUv45s/Zt3lin0ERb4a/1WhSOBsDhcKgkv7aVAACWifkA7Nil+mNF5aFh3Y0UFmxvQWBN00JBJVxrDI2W3GtxpgZMV5aVzLN9HWNq9uhjiHClUiNM8yuKC76yKKSQlC57pYqYVdcsXpWaPfoYSwLSwH6pkhYoYo/1AxEA8OGU2TuJkR/57vmW4pkzayPfrzK9cNUCopqjrqaxlUiImL3rixPMxDOdiRhQEdnUJy0ErxYkB5eX+F6xOxIAYCEnoS53q1l+h1NMsCoeM8pKjn0DgMoMqJPJ0ImNLeIUbH5wRwj7Tuum/PmLUFtb+6wzMeEmRGrgQjz/g2d9CyPSVwAMmF9ULdDawlBiFoFrlZJVJNTG9fvIjDYqb48fMhZvfKLFf4hxd3lxwX/sDiQO/QHgaYGaJzcWvbvX7mAAwNXPcxokn6vYzO+GYVzhcudaEpM5K8DAZsUUQOekZHsGV5T4llgTU8vF0tEWZG4ZKTNFx+Duo+cWbDr7+tEvMfH4CPRb6TBwawT6aRQRVTObXPvLHNeDkmCxQdWk8ICaZRRVRwkDFmijsrw8weGoti6aFmEdMxaSoJfKi/Tue4tVgvA5SX7LXy3mbF7p2213QAcgGHjcgqSI6QBsWW93ICtyOxLhccDbTyc2VsPEpvNTCkhbb3wOmsKuTaDHnH6+BuGvWPHYu1N9a8PcR5OYWeGDk9KsiyR2OQRVS4XRCxF1tDCcqEMSHVUqKki/YeudX4zwg+hmJvlBxTcFa+wOJv7QIhA/mtymzZeRSOhrRkpO7mgw97M7jujC2a6cFReXF+E1uyOJbdzH7HBbEtm6FOSgeZePnnrzNwbmhLdLWueoqoyCNQG0R+Hk9t2P93SzLJRYRVLlPQQYvS2KJCpJwUoLm4WoUnt/WwYnJPfVA7vwYPBJhqQN0Tqw69VreBIxHrE7jqjE/FD3kz1xva453BjiOLPnElBmZSyharD4VDr4IYdBFwV6zQrM8tZ3Z9q/ToNIbmKFaRXp5CwAv1sXUeypMRIqnEIhHyxBsTxQlGORpZD2a/fG4sj9nhDhEUn8YqT6O5AwRAcmXgSz5c8IV6S6R35TVlzwnLWRWWYrCz7Rrs5J4laAxpo6FzjUQTw/5bhLTq74blbU3Wzsad9mHMCZdscRneiw2mq+GdCDXzPS3OceIsF9zM9AngAAIABJREFUzZ5PoOga3C162rfqrOtHvQHC3y3vjbDkw8m+eZa3awKBy1lhdYMETgfwkXURxZ4t7cs3uXZ1loDJ1DCMk62NKHrsuzAcb74FjmjuR2Zsqyiyb/YrJTv3MiK8A5PPQBj0bNe+nv9uWu77wuLQrGDYObPYq9fwm3e3b30iALfJJo6lxL0vAhgDm5MUH6jHsRd2qEHN3XbHEc2IcEfKcee/oHeLh05y4jkg8xtMGfjZynhCFfBDmUEPQGU3aWB+GHyTxW2aZgjHRsUmLoTH47AkmFhVV8ZJ5aJxtKvfiLhcK8OcOAJKyVRJ9eczplSUzHsPwFMKTSQKwfO69PO4rIopXqxa9WG1hGM0gB2mG2Ea7XLnqlV+sFhNYs0EAHG9btcC7ShBeO0OIiaRUCnnJrkmeaVlsZgQcHD34ZS3VjNgcVJKmvbBVN/3Zs70vn5q74mzBoyxMpqKr7PWAVB57JXmWi1HWhVP7KIfVc5mQ6glHY1SDLpK7Xz8ZFUssaIcHe8CoJJANs0h2Qf3NQlWxRQvNhW/tRrM1yg288+UvrlDLAlIkeuECzIAXG93HLGBrk5zjzza7ihiics98lKA/6LQxBq7lzE0/jiN6UFYNXtH2JQoqr1mTvV6ISTLGSCecterJ5pbkxO4ZQmQ2gco0dOd3SPUClTHOpZKdydEuDI122P2cVFUSsnJvQCE01TaEMRKg+aYVDyzlqQcjbo8amYNcPFWlRnAuFVeUjAX4OkKTThJ4M3UviPSLQvKJHLUPgwgye44YoRTkoiCTYyxIS1nZF+A1CpnEWzPr9no4M7K2TsCT3j7GXOlf2SvAWNBGACgU6Ij4SEr4vkT87eKLaQ5IT7edxfZIrEQqu+hk4nfjpc7S1dO7kBivKDajpTiv1bEE2vKls9fJ8BXQGVtF9F4V06u9WuG40By27a3MKDyO9uZhSjIGHiZbdVXUvuOzGGQpU9y4h7zua6c3IF2hxHtXDkjzzKYlkCtPjGYabFFIZnW5EJ46eCHoDp7R1zUr0PWy2ZO9c7pnwbwnwM6Bq65941TLFuET+ClFjSTBYf/u9Qcz93dTjzfwpnFGEHSivewuwR96crxjO/Va3hM3o13cHvap7hzHwRjEaBcwaTGQVVfWhFXLNpYXPA2gScrNcJ4Ls09ItuikOJG6bJXqpwOx2gAuxSacVft2qUyA6iEhXgM1uT6bVkYTwDeCNdFV8n0GTkpbs+xruzcOWB6n4BDFZszUOu3fXDXZLqTRU/7Vp19w6jXGLjCZPvMUlzv9ZrLki0N5OPgN1qQQc95lw50ewctU35kXMsJS5xkyZPntsz8kGE4vK7s3M+I8F8QfpAGVgmi7SSwG+TY66wS0ZTVvVnV5Khpbt1AxTcFa1zu3LUAVNMRtAfzlN3tW9/jco+cz4T/OEn8mNC69U/RmGOrc//z2jprnEfDEH0AHgTwXwG0s6j5ryOZBiUadawSt29Nwikg08lpW0mI+WnuMTkbi+dssTS4GPf712/9kpIz8lpiesN8K3SZy537TXnxvIjWJE/Jzj2n7vdNyW4AsVrar4PCue7U7O8vLCvB65ZF0wxmcUSk+grawIHO1J0pR0jI4wTx8QwaBnC2hbcLC6Nhd3KzuezY8D8Ah/NimKlaQfTqh5PfMjUDce+s/qMA/LVhmzjO2FiTB0Dtzh7AluVvbnS5c78CcJJqW/s4QTiNgdPAAAmAwWAGwH7UhLvuh8UIQGp27ufS3+qMZgZ5BYBl5eRSABpLjLEGM4xduw2XO3cnwDsAVAJk46CH2wJoBVAbVO27yNKf/7EMgRZY2mAMWrnSV5PSb+QFkFSscCedzuyfA4/nTPh8hqUBxriKooI5Ke7cQQRcrdDM02k5I/67sWj+Z5YF1hSPx0FreJJiK7u41ugVDR++ZrhyPO+AzdfQZaKHu5/sKdjwha/SyrgaRTwy1Z37CwM7I9Jf41oD3BqgNtiFDkwGCPvXflib3YeYbMkXWl+zg7sPps1fd9YNo14CcF2Ibe8yqHaCmaDumOtuTzV4urHXiemhu189ueDhS7+wIIkwvQqwVYO7uMOEU4Rz7/lAE3d7gl+BpHDVCnYA6ACQyh2rRSLyhMHvF1CYUYkfFd8UrEnNGXkVM5nOjcnEQ12r8Uh5FNQMjTYJiXSjv4b/AuBYk00kSha+zu4R7i3F88OesDV1tbyCiRSr2tATsTqwAwDB8nYJGg7zRQZ61NbgRgCPWhhWkxiIktm78F+/Cfi1jDq8F/aOghDU83enFA8CCGmkz4T7Fz1j7hc+qTr5SQBN1W9t63CIJ820XV+yUTsHKvmfWgISXZt6ufybgpUg+iRS4cQ1pn9t/sZXbncY0aKsqKAAzKo7125zuXM9FoUUNzZ84asU4FGoe0xpVmoCi3lZWZ6wPpdIOe6S1kx0v2IzFUaVUi5F220sLvgJwEyVNgh8l6uvp4tFIWkHkISJKJ4ZFY/8gxrcvTP1zY0gPB98s/Qr5C5TF+R73zj1NFBQa/xGT3y9/3AzfRyo9Nu3twMU07/w4cZBLIolw7g3ErHEOcnC77U7iGjTZufeWwEqUWiCALzk6jcyvsvdmbCxuOAnIspTaYMJp2xNls9YFVMg5Ky8FYBq2qkHNq/0xdS650C41rgfao8520Gw16JwtP0IX1QU9Zlrdxj7Bb9zppb/iaCT/sobPpzyYXWowVw/eXgSSfkcgp8/nex9eaDylnx/cvXT3MLrxKoqWz7/EwL+ZXccsY1fqyhasMLuKKLNqlUfVhuM0VD7QGtDkhZknPA31Z1wcaesyDcLBFMZDf6Hxrqycy+3JqKDdenncYHU1vQS8Gs5OoYwQRG9Kr5bsInVH6vqxMbW2m1I+ntd/tzoEPTg7oN8XzmIpjV7IOPtDyb7FpoJpmPHnV4AofzA9TISam8309eBtnz2zi4muhxRVDcxFsla4xqolSNrydZVQ0RNeb5os7nEt4qZlCosMHBElcM5K/LpIKKf4OrxANTKJRHyU/uOzLEmov8RBnuhnHeM74mWx2VWSEikZwD+TaUJyaS6OUWrw8S4bnOJb5XdgRwopItckr9mEprOj1QtyDA12PK+cepxDIRcu5AYE+6Z1f8oM30eaFOR72NmfkS1nZas4rsFm1jwRQBq7I4lxuyVksb8UezTaz+bUFHiewvAc4rNnOPKXqGXENSzsfjdvRA8GmolGZNZUIGV67lSs0cfQwS1EoVM35SXFPgsCikqbPjCV0kk7lZqhHCeq59HqZKOBgC4raxknsXlWtWFNLhbMG3BVgY1moKEgMfem1zwa6hBeL0Qsu5xbOg1IQlJROppUQCgoqTgXiZWWqza0lV8U7AYRBcB0KknglMDQu6m5b4v7A4kFiS3bXMzgdSqdxAm1uVL0w5U/k3BSjDGKzbTA4LfxMCBZndzHoSFnATzO0Pr2gDuRBw+lSkrypqtuBYVYH4COiG0WRLAbeXF8yzZ3Gm1kB9PJInqJxC49uOG2sQkU9O8steAmwGYrjxBwBkTZw+wYjccVxQdO5aZH0YcXgwipbzINw/E5zFgquRcC7IZkGeWF8370O5AYkXpsleqhEOMglqFBQHCrC4njIySFA3Ro7xk3stgnqXYzGDXrs7KqTZc/TynqeR0AwAQFlaU+JaoxhKdvJIZtyk1wchJzc690KKAWoy6zzY6r7x43hN2x9KYkAd3bz/z9nZibrAziohu+eiJpqsZBHL37FPSAQt27jBPvmOuu71yO/DKipKCe4hpJACdksKk8qKCD6TBJxLjc7tjiUqEQiGc7vLi+VaUb2tRfv/6rV8YFGrezYMQcKjDQQu6ZHmU1nLFI6Na5AH4SbGZf6Rke0YrnE8w8LhiDFIaxp2KbUS1fQNXpbxqTHjYzlrBMWiuAdm7vNj3vt2BNMXUwuI9Bp4CsHn/3wn49P1n3zKVaNTBYgYUF8vu40quSfZa0A4AoKzEt6AadDSBnwUQdeWvYsHmbwt+LSuZNwBMlysu/o0nqwCMKi+aN3TjN2/q98SkimLfGwS8oNhMliOZX4J+LHWQzSt9uxk0CiHmNq2PiF9McXtMJUhOyRl5gULpOQAAE97YtHyB2iP8GEDsuB1qNeDTq3btvtGqeOIVMS0G5ODy4nmjI5G0W5Wpwd2yfN9uYux/zmwY5BgHE48x7339lIsBHmYmhkAYuP7eOSf3taq9P4p9O8qKC26CpB4A3QdgrVVtxxIiVtnezeUlvlfK227tCebRAJah5a3HqwVhITOfV17c56jy4nnhWdwthenvk+L32BaORLoBwPeKzXhc7tyxQR5rdqlGzC3xqCj2fU/Mqh/4rQW4IOQExx6Pg5geVuy7mvzOFrFxpqzkrR+hfqNzV49jL2ykCpBsybWZN4EwjZhyykp8p4f9SQupXCvooHNNpwSoTUqaCqAChGkLn53zXajne+ee3JFAVi9EdJAhZni95v9dgZQv920uL/Y9UF48r6cgzq4b6NGilrKmTEKsVm5k2TJ/eUnB3PLieYMgKZWJr2TC6wD/ghj88GuGAdAKMF5i0EXJhr9redG84RUlBe+GMw8SCfM3HxK0xspYImF/hQULfg+DTIZu8j0ixNx7CwBlJQXPA3hNpQ0GjtiaiF6hnJOy2ugHIFOlXwBTyr99s1SxjZghnQleqFVaal+dUHtGoBdqnK2KAbSUAV4lGP8G8CBLDC1vu6VbedG88WUlvuJIdM4SptOpENNBn9OmdyF99MSsPWfd4LmNahJMPe+XtY4nAG6yrJVJ/WSvU64EPg9LwsqNRQXLASzf91fq6h7d08H+Xgz0AlEmgM4AOgHUGeAEAtpxXX3UWFTDhIUVRVnvAdZNNpUv920G8NK+P+hx7IUdqhOqjhIQh9e9j5wCUBfUvZdtUbeLOmrWRjGwkwCDmP5g8BYIbGWJjQCtFixX1x5S+/OWz95RWfBvSnmR72uXO3cigNEAWgV5Wg2Ajysy6T0UhS+2cNlYXPCTK8czDMyTAPQw0USVAAdV6FuyvEkIegoc0sDjd5AMOcVTtChvu+XK1F2dtzP4dICSTDRRXN5+8y8hneHnNZSAjxk43ER/tQRemNS2bYuYtdtv01dzKlKyPSOI+H40XbozMEKFZAQcwGz7avZOV78RZ0E6vIDsBZAlO6EjjxmguhtBwmZI3gzCZoL4nYGfJcRPm3rKUvh8tj1ZMkje74ToRMDxoYwbCFgthf+Wel+LvHvfOPU0knJpGPvfJiQf4/375zqhrqZpmqZpLUrEM7XXlRjj6QjvwLIjC519W9M0TdO0lifig7sOnXbeDfAx4e6HgUsnzu4/KNz9aJqmaZqmRZOIPpa9Z1b/owTwXxDMrN0wY2X5nqq+M68tjpuagpqmaZqmaU2J3MwdgwTwQgQHdgCQ5TokWRdj1zRN0zStxYjYzN29swdcQ8wzItXfAfYKh5HlHfNlqQ19a5qmaZqmRVREZu68Lw90EbNyrUGTDjGkeNqmvjVN0zRN0yIqIoM7Tqh9FkAj2a/Dj5j+NvGNAWoFqDVN0zRN02JA2B/LemcNOFMSfxjufoKwfq9s3fuJv3+0x+5ANE3TNE3TwiWsM3feGe5DJPG0cPYRgh6tHXsm2B2EpmmapmlaOIV1cMdtWj0IoGc4+wgFM26957W/hD3HnqZpmqZpml3CNrjzvnHqccx8fbjaNylRCMdzYHvKrmmapmmapoVb2AoASymnoq7ge7T5v4lvDLj4AXw6K9QT8xenTwBROwBggAnYbn14wSNQWwZb+T1sBw6+WDEAEGEP1xWfDxkLPDNuUGl5U8e8+OlRbauqqycQo6OZPv7sC6gi4p0g/MhES5rr1wpTF3fr5BAJFzHoSEhOAHE1MdZJwzl33LDVv1nd34ylR3b2y5p/qL5XdXgHiLYKppKaGscnN5y1qrrJoxk0fWnmrZDcS7VnIuwBsEMSf59UYyy76swN25o7J39xxt8ADFftG4Q/AJQL5q+uHbLuSyKwapPTlma4HMzZUuJoJuoCxiEEJJsLj/yS5dRxp6/7sanjXljYvWNNouNMQGQBaA/J6tdiwpd5Q0pfDvZw71I4uxg9+wLGcYKoOwiHsMShprsXWDl2cOnkYI6dtujww4TDP0qCehz4XhNhjwRvJRbv5g1d+53ZWAAgf3H6OICO+1+AMEDyxbzB64uBuu87SZ4AprDldmVgwbihpQvNnj91cc8jBfEoJu5OErTvev59UlLSvCsH/LzLqjinLErPdCSIXJbcvf73gwmbhZT/um7o+h9U+pi2JONmkjj6z7ZBfgZmNPZ9nlaYfjcx9VDpMzDeIQV9Nm5Q6TtWXD/MCssMlnfuyR1ljdgajrYtUlFDdMyjF336Rygn5Rdm3gPwg+EKqkUhLMsbXNpsebjpi3uewyTftbj3GmJ6IdnB/7h8UGmVxW0DAGYUHna4AccSAIEuHrvAYkTe0DWLrexz+pLMUcz8lpVtAgADFcS4I29o6auNHTPlo8PSHA7H71b3DaCSCFNEu073XJvTeKWZ/MKMnwEcaXHfK5nF5eOGrvnGzMnTP84YyAITAZwGK5+SMN+dN3TdI429nF+YcROAhwEcYlmfdR2vyhuy7ojmjnrx06PaVldXTQToUgBdLAxgT96Q0jbNHTT94/S+LOhzND2ANphw27jBpabTZOUXZmwH0L7el5/JG1J6MwBMXZLxV8F422z7QZqfN6R0pJkT85eknw2meQj8Pv3qkGLotaevWa8WHvDc4vSTJdEyAImNH8V+At0wdkjpdLP95Bdm1KD+hBLRI3mD195d/9jJH/RKcib5w3Lt/xPz+Lyh62zbcxCex7J7kpr4JkaFlESJh0M9qapV7ZMAwvEB1tJIQN4a1JFkhGP2N5GJ8yolXgtD25g7Fw6DHa8j8MAOANqCjDnTlma4rOxXMoc06xosAlJAeCW/MPOqxo7hhKRwLfFoxYzbje1bX2jyKArLU4IsIrl02sfpIa/TzV+cPoEFlgAYBIuvs0yN35RPX5J+BYCnYfnALjhTCzPTq6urvwPoVlg7sAsaE3nQ/MyogxhP5RdmXBeuOISM3uU/0wu7dwPTLDT+Ph1hOIzZXq/6zy4TjUaTAzsAICcD0/IXZ1yq0lOwR7Zt5Q/794aJzgp3H00JywXZe9myCgDKI/6wIr7WO/vkE0M55ZZTNlQSQh8UavUQZu1/dGEzz9TCzP+zutEtnTKuBuEvTR9FnUnyY1b3HV78+LSlWc3OnIQF4e/PLU4/2YaeW5OgkBKwT12S8VcQPYQI1+72eiFY0kOR7PNAc+fCIcDvAMiwKwYAYBHSo7ap05akjwhbMFHL+Tiayz3LNKDrqZlXqPYkG7/JrY9AeP65Jem2DoqsQkBbO/sPz5o7AvNsetimcmPBEpJpumeu50TfKJ8R7EkVovT5rjLjegB61605lQ5DTFRqgbAW4NUhnOAEcDgYh9V/RYAvAPCJUjwHeHppxqGQeCDASzvQ4BEOXfzc4vTp1w1d94VV/QewCcShrS1iuAA6AmhQB/pQGHvOBhDso99qAJ+BWAbdtcShRHQEGj7ugkG4EECQ7xX7CeLfTDLoNS/E1JGBY9FwrfDZL356VNtg1yAJCS8Cz65JAJsI2Mwgc+tUwTVE9Gmg1zr175kFkqkBztoN0K8ABf19CIQIhU29vrVz5kgwH9fIy3sALgPEDtP9Q5YEc5xgmRTCnjkHMc2eWpg5bPyQtZZdB+rQGoB/QfOfs040HAD9se9Pkxgc1HtyoGmF6acwcEGAlwJco/jhGR/39F17+hrT3zc0vI40JUEyzZ1emDl47JC1Xyv02aTLBpZWT1+S4QNIOZsHgYmBvojwzVxzwrahwvHrpy/IXv0vB5qbwbATZR9dvXEsgKnBnuEdBH9+Id0H8NwwBha3mPkJ5XUckp8MdS2D1wvRdUDGQyDcdXBA6KsUSz1JEveh3uMoBiqMaueRzqTaaQBdfMBLJIme9XrxF68XSh+8jePX8gavuy3Us6YvzchgiY8AHLTGSghkI/jB3bd5Q0qHhNp33Zqt6tcBnHfwK+QOvhVaN3bI2qGh9j1jacbRhsRnwEGbUhxV1VXHAvi8ufOnLErPBOGEBi8wFTgS5fXX/t+6slBjChY5/F3BDR7G7JUQfcYPWbsuXP3ux8znB/jyHyC6bNMna98L3894EAi/JSUmZVXXVM0HU/2fi2QB/tf0pYefOnbQ6hVWdblvIf9RzR03ZVF6psNJaw4OF8+OHVJ6v1Wx7Of1QoDxbIObD8aiVg78rVLiOxz8O99VCnkfgFssDuVXhxT9pJDvMFD/6Ulrhnx/6uKe/ccPXfOLxf0CAOo2OpSOsqKt/CWZR4H5v6g3iCXYt5kCCGcqFC8kE40HEPSsmB2I8LB3Tv+0UM4ZO3jtPA56BkE7wCajJuEJOzr2eiE7b2vtRd1s0v8Qd7aqjxlLM44GMK7hK3TvDWet2kkw7gRQv0JKv66nqqwzaQabu8CMHVRaCuCpBs1xCOuoTPZ95YCfd0mSDRKOE2DZ96ox1w4q/QlErzR8RXQK5nzhpIY3s4wyf43jonAO7ACA2NFwzSXjl0gM7OoCwEkNY8JdeYPXvmPrwK6O/8oBP+9KSkweAVCgJSGHsjQWzvi4Zxh2T0aPrqdmXEpEOQd/lf1SyLrNZUQN1kIzMH7ftc1KtdeevmZHlcBfCfi+4cvUWQi5cMYn6QFmoqPDjMLDDp9emPEyWK5AgNlJCYQ9I0NTwprE+MGLPi0m4Plw9mGBdtLgkAYcRGAG3RmugOIX3X3DWat22tX7qFEra9BgQwxZtvnHkHgKDR/pfddl69qXAGDskA2/E9GkAKc+MvmDXu2sisMyLFY1+BJZ9341RVYlNugboT3eMY0Yaxt8kYPrm4CUAF/8qrlUMlZwBBhME0VwUMUN/+0E+Z+I9R+EKwf8vCuBcTaAQMs6uhlCLnxhYXcLUglFnxc/PaotONCacXp+/OD1KwEgb/Dad0Bcfxd/gsEwvau4KTcPKt0O+Icj0Bp9RqZRQx9E27Uxf3GPnvmFGS8ZED8xcNm+ZT/17XIwPxPp2A4U1sEdAFQTTQBjc7j7UUNjvLMHhPQIZ9/6jGiomRsrftgk1r5idxBoOJNsydT5vkXADfOssfjHqFH/67MyufYJNLyQuZyJtfdYEYeViKXfrr5du1fZ1jeDG/QtRHBr9yjAWkEAYZ2x+x+5u/5XGDgiEoOVGUXuBATYoVvpEBvD3Xeorh66tsIBYxgDFQFePqYmwfnuU593bxXxwMKsqrp6Agj1Z8J2+BOc9x34BSLnzaj/O8A4c1ph5rnhiGvskA2/s+QzATRMn0Y4wZnkf3vyB70icmPXlCmL0jPzl2S+ABI/Abi8kUFdNYimORL4qDCvpW5W2Nbc7ffoRZ/+MXF2/7vAaDqVgc0ky3zvywOP816+LOjcN4YUdziEHIYIDJJjHRFu8Q6CbR/YB6g/u1D/MWnIZhS5E/w7tj4ZYDXtu/Vz2d1yyobK6Ysz7mDCnIOOJLpx6uKeL4RrjYkpxN3qrxEWzI3mmrPSHx16dkODSSc2tQkhVASk1B/JSUlB/ZxIZgdRg5+EwfmFGdas0WVUJoBuv3ro2gYDEz/8vwgkSBx8PWpbk+D8flphxleE0H7/CNjDjDIBWnrtkLWLm0rIuqemwpkc4OMkWfLz+YUZltxAMdF74wavtSR90bVDfls9tTD9LAItQ8NdjackVzrf9C7FyCi5Zimry7uJmxu8QPTwDf+36qDJl7GDVq+YvjhzJhPnHXQo+Mm5c7MW7XsCYqlxp6/78bnF6edKosVoeJMwyJHkf83rxRg7Hu/XrT/muwG6FNxoMvBqBj8vYDw6dvCGqEiXFvbBHQA8cOFnL02c3f9KAHakMggSHSGdtbcBCDpJ8fWnr/k+vzB9NkCXhDGw2EdYOHZw6SK7w5i2OONMAAdN8TNQqtqusWPrOALqr0mpBVHAjQzXDSl9a/qSzPEA9z/gy4kC/BSAc1TjscKMIneCsWNrgzQIDN4Sif4NB18b4CFj2BOje5fCyRINUmOQoIaPaoN3FIJYWB8UAvzEbwBo8Ps0fujvW/MLMxah4QxyGgGBNjs0iff1J8F35RemF01fSp59azFDaINyQ+23McTcFbAuN+X4IetK8hf3HAGS76NhHrbzusr06cC6q63qz05+OB6nhssa1virHAErfghHwn2GrBmDg9OlHLG5456bAIQlhdN1Q9d9MX1xz9FMxoL6s2IEjOoyIKMcKL0xHH0HMrUwM10wT2CJywFqbFBXxeAXBIxH84ZEx6Buv4gM7kBgniPHkSG+AUIrbxVhd3tfHfCW99JPg549kRD3CvAoRGg9UAwyDEPcbmWDRNQ/f0lm0DNIBE5miSwQ/h6grWUqsUz+pFcX1Prvq/91ZkwfN2TtzwHjIfBzS+kmKfkrHDjLQnx2fmH68Lwh6yx73E9EJ+UXZtwR9AnMDhB1N3ZsHYxAAxLC8uA7R1pIfePPWbMcMJ8a4OXg+wba5S/JvCbofiUTC6SRxPn70qEcaOOmT9b+GkLftnHAuN6A4wtYnECYiHJY4r0ZRe6+TVUKiTV5Q9csnlaYcRkBr6PBExi6atri9LJxQ9eppW6y2fTC9MEcYHBPxLc3thb02kG/bMkvzHgAOHitHRHumfFJ+qxwbQ4aO3TNe/mFGdcAeBH1HhsQ4YbphRllY4eUhpR3MlQzPu7Zw++QE4j5clCjyZerAH6eYEyKtkHdfpEZ3AF4cMwXyye+3v85BNxNGCUISdKByQDODPaU8UPWrptemJHPgaa8NYDx4vWnrwmwG0qlSYwB85gQjm8sA9EOv9Pxikoszlr/A0CDepnbkvz+JtMYXDdoTdH0wozX6hbkHoienjs3q9CqRx/70gwEn6i54SPFA+2qJvoghO57AAjpQtzk8zvCmyE01QXFrGovAAAQFElEQVQh5Nlkqus8UP8ETImC3Z4HaLi2br9rh/y2etqiw92UYDwIxghYm0g1y79jay5Qb0lBhLAFSygCGTekdE5+YUYK0HDTABHdm1+YsTFvSOlz4eg73ObOhWMrKNDC/v+MHbyuoKlzHe07TTN2bL0OB9/ktTX89E80uG5ZJ29I6cv5i9NTQdRg8wcDj+QvzihrqhSiWdMWHX4YOY27DMgriZsf1I2N0kHdfhEb3AGAgH+ChHME0GBRZxThYRNnnTLygUs+b/IH/0BCJD5iyJorEHgxdQvGux2J8NodRWC8G8CY+utNQpG/OPM4gBs8tmHGA8EUuxcJPMGoRS5AB1Z9OGprx93XA3jSbFzhQ3ffPGjtdps69+UNLv13pDsl8LwKsU4xfQ/PAvGzVsQjJCqvHbz+x7FNHDNu2OrfAFw2dy6u3Nol4zBDckdBwZdmqkMuMD0L4PCD+gcPQgiDOwKdxGRYkg6rhkQIictDkzek9JnpSzJSmRHoKcPU6YXpFWOHrFsQrv7DZWunjGsCzERLkGx2MuLanOLa/CXp/wDTewe9wPj79MLM/HAmGc4buu6RaYXpqQQaX+8lAuH5/ML0TVY94Zi8tFf3BMO4i8m4Eo0/gatixkwpjUnXn/Fb1G0SCiSigzvvxV/tvHf2KROI6eVI9hsyoil3zHUvnjSqOKis3NcO+mXLtML0xwn2lf6JRkTisWv/b22EdgoGrZQZ7wgHPR3q+qEGiJ9BgGUGRDg/f0l6s2vnDD8AUCWAg0p6MdG9zy/OfD3QonmbbAfzPXlDS+0ogl1LTM8nO/gfEeyzCsBSZnpp7JDSgqY2EtRHJGrqz/8xU+24IessK7cXbDHUul3apaUwua40f3F6BogOSvDOoID1kLtv2FCzpVMGo94cuZOx7uoh66Pl57hJ1w0qvXN6YYYrwPINB4PeyF+ceUbe0LVRldqlKfn/6dGBa/iBAI8tKgF6NH9JerBN1eLgFE/E4MnMODmU341Qbf7Puhu7npqRAsBT76UEgHyqVSymLu7WSZDzPkj/NUzxM6jbL6KDOwB48MLPX504u/8VAAKtqYkWqcm1rSYCCPoDpbqV8VSrSsd1DOoexrhiBoE3iD014Zp9egNEQczi8ClgHJwgmPFzl22ltxyYnsSMaUvSR4AxqJGXTwuhhnUg7WsFHgZwlUoj+/wMILTyY3XpYraDsAkSy/cYlR/fNqzCzCOxrQCWhHoSgbczaBuBVvoNf6HJi+omEN3b3EEM6SSmR1Bv1p1Z3Ddu6JpvQl1DQsD2+p92JBBSkvRowUTbGvwUU4M8jgDqBpL5hdiFehuWqkl2Q+CUI1GHCDyjqNNVxo6tXdBwU0oyiP81fenh/2dlFYtwohpxHwdO/N06QJWOUJ2UvzTzEsCa3cuBeL2Qkz9wXuJM8ncGGlxrWzP4vamLew4wk2HAuxROIRM+Q+MbnSqZ8XwsDur2i/jgDgSWs3C1AP6LxkfLtmPmG7yzT5nlvejzb4M5/pZTNlTmF2Y8DGB6mEOLCRJ0+9hzN+4NR9tM/Nm4waUzmzvOuxQvdeWMnjjwRoIwbHOnjIeA0rsaP7NpLy/NSK6UeNzs+UFhvjx/SY/peYPXq834ML+TN3SdpRtagu8bv+YNtabEj4nOd+YF8TMCAPmFmZvrlRNMFmTMf35xZk6os6cSWNdgQMQ4dcYn6anhrlBhNUHcikO6SeH1APU5qA3QKAAh1z+1y7U5xbWPL0rxtHa2KgQaVNzoAOn/cMbHPfsrl1AMs2kfpx/DQF7zR5pHkh998dOjFgRbc9mMG85aVT35g15/cyb6/x2grF+XfVUs+of6u9XVyOwN4kADu0oCZooEnhRrv6/12ZKf7aFLPvsZRLaUoQqBU7KY4fUG/x513lr6PIAfwxhTbGB8mTe4NJTF72HhHQS/XzgvBA5Ook3AHfmFmfWn+oNWybgZQP2C0waANQp/6hcJF2AxmUOogK6ZkzdkrQ9EBz1yZlB3P/Hcfcl5g+YUCV+g4b6M1kYtLZ22OGP0tI/Tj3l6aUb9DThRZ/rSjAzJ1HDmmNHoRh8KXJLx1umFGU9NXZJx0vTC7t1CfT/tcNuwij0OkXgO6ma9D8Kg7sb/t3f/wVGcZRzAv8+7yUEChYCIMhaSALV2mNFBHIYCIvkBLUmdqgNoSwuToTa9BCLUolgpXssgwlT/KCSBDpURhNa0tuMPhlaSgPSCitZqO7QOAnexpZZfbekQINzt+/hHghx3e7m9n7uB5/Mfu+/tPpfchXd3n/d5lH65uXXsXXBxhQQyyKJbDp9Hen+jrq0BSxjV3d39w+y9ix4NVUc/NjxcBbLsHFNqhmhPT4Flsv1/NZMebLkdqPNWBJf194kd4MSdu14ffnDTmmHDP56LTNV/ygqerG+ZVgN0PGNn9Pz5MJvb+TFmeiHbkbkYw8DybOZiJKOh7Oi7ja0lC4mwG1cvZgjQP2/eN+7tZB+xbDlQPMoM8aMxeSxEm+vKA9HJv7Y17y2eyIqiSwVN3dxWfC/QuTPV4wp7wpeM7+YNMKcAPOnKNgZmmOfO/BRAg93j9OTfluwhoCpq161EeA5EGKCBpraSVEPVTFRjVcy3t4H5PwAMTPXgV7C2XmDOHD9/T2tjOykdvcDIYGC5Yixn5ME8dzad9/5WXUVwQqovTkZt2ZEzzftK7mSNDiDmsfptTPp3uYgjFU3txdXg2IoPzPRAfWXwV6ket7mtdAmDN0ZtXta4b9zW+rJjVu0CM6Z2Rud/N7WOvVOR9iO2zM8XCPzbTJyHgG1NbSWZWBPAYH6krrIzpj93rjjWWWFjw55uxfQQMtT+KWsYG37Q8mXbNaN6l5cfzGJELsc768qCf3Y6ikj1lcGXwYjq6UqDWYdfanp1zDDrV1nrKQNA0Vd9HxmU70snRu+sztfBiLmIYKL1jfsmWF5lisxpqDrabSD8TQBRi6hoaWN7aUx9xL4ozasAZCUlAYAC69GWezRGIgMTu76Qwovx9tXPOu4H4u/PANsrADLBWxYMgmkOYj4TfSA41jsbAFpaJnjAZJXrfLCuIphWl5STKrAZ4OiL4QGkzZxMYJZUHj/CrKp770DaQsxZe2Sc6NRENMahcwNwuG2W737/fgLcfldiuOeymVzRRKaVWYrF7S4a2sj6bfpUnDKCqwFErXSj8bisdtp99N7cVjoZjJhuJAxaW1t2JO3ODWFP3ioA0aVGPkN8IeX8QGFfbcU7x9jiUSQxb25qHzPJ6jVWvLM6XwfxfMQ+au/n+JeJytF0hS8uZCCZWoiuVlcZeAOEu2F3sq7J0WLXZ4afX4LYp2GsCQ+n+zTFV4YwAVYdIr7a3F5yRzrHtqu+8vhfiWguAMviy9E0seViCyKV9W43TnO8J+plM7QMQE5aGqWKQTW+HdNn2h3fu1w+I7eJ+xMGNmQ60ZgpNseHWCVd4LfnD1P4HkTl3wGYM3JGqa1V0Uy8HrHfmWNmtxH9qCIlDTOOnma2qAvI/PDGP4xOuOJSkUXvVaVy0k2gwDRjz0PIXScDjj4XpXTu+srACwzeFLW5AKxebGmZEK+waYy68s7dRj5PINBagDP6yKqn3EosrbLWe/cDIlp9SnXWJBq44o6TXfUVwWoingum3YjO00qPrffHoNhxfeQKJlJXHvwjaVQDSFC0ljq6zAtJ18JjT37MZ9Xq714iz/hvvSnOCvFnl5QH/5Ls8ax4KzrbYXF3lpnj5tCT1e8tjd+Htzz4ChHu5sSrsNsL4xRdP3Ug8G8CtaUagx2M3PThjsexnLsr1i06dHb1zmkrwdjqdCx9IE286cEtkyY+XWuz9Q7R98C6KrpH3nXsxIXwxYyvIC0gausCvqaYPADApE3zUl5rKsfyVrx7Ykvb6NtN5H0xcrtp0r/svJ411hNRU+Q2DRyK18InFaf9wY2fmj72GBMXRG73UH7CUiSqK7THLPB8HdTTB5EZrMLqQKZi68u3KwMnN7eWztZ0tVuHYvNwLs4NAKT5W6zU+Kv/1ilPqE6rzuUjuXQvOCJhnjkEHE6qfE5vUvYqAKu27B07NEz4LAFDGVxElNpCGSZtUr7eZ7XvDAVfG4niu8AquvF6Sojpoknme2dU5xu+MoSTeW1vesqvW1pgnP7kuFKY4dEKxqDoz3VS8QCddsaFVd73DdN86ZqfMccujkiGd1Zw/7Z9JeO7TZ5oKowiVldzYwnd0AjWVQaSLTkEoCcvuKmtuApQg4Ge722eyt+f7HHOqa5wARkPMKv/X4AyaXOgZ+DeVOKKp1thsYd5Z+TPQPcxGdWgZQrYdc02Zb6VTgze8uArPzt4c+mAi8ZERRh1zXsGLimlAn3lU/t80D5fYPbIr5RMZpNuTvX7GA8z2ANytCaiO1biMeixXdNaiVHudCh9YcKKNQs6bK/ybW4rfppB10Xj6UQItNBbEdjhdBxCCCHEjc7xx7IAAAIbYfIis7fwM44Yj/uenVJid7zKx4+QpX6IbkLA30++GnB77qQQQghxQ3DH5A6Ab5H/CAEbnI4jgULTNGx3Xeh5LMMxzaivN1qr77irsboQQghx43LN5A4AKJS/DhaFI92EgG+s3jG12u54VoPX20j87M+e6y2BIIQQQggXcNXkzlez/xITLQByuMouFUSNj2yfPcjO0Pqyw+d7Vsxdly6RgpTpEEIIIVzEVZM7AFizwP8aAeucjiOB4kJlv/bYiLOFWzJdDsENiOjH3rJg0Ok4hBBCCHGV6yZ3AEBHOx5ndnshTF6xavuU2+yMnD//8GUi5crivmn4pxoyPLnizkIIIYTIOldO7nw+6JCi+wB62+lY+uAhw9gEm43dHyoLPA/gUJZjyhE+b2p1f+2XbNb8E0IIIUTOuHJyBwA/WeD/0DTNWWAcczqWeIhRvnrXtHttjSWwBq3Idkw5wERq8dJZx990OhAhhBBCxHLt5A4A1i760wnFVA6QeycSjCd922YWJR4ILKkIHAD499kOKYuYQA3e8kBaDaiFEEIIkT2untwBgG+h/z+XunkagN84HUscn+b8y7ZXw2rilQCSamPkDhwG6EFvRSC676YQQgghXMQd7cdsWr1z+jwwNwEY4XQsUTRrmrpmod9Wc+am9tKtYF6c7aAy6ASY7qmrDDjaK08IIYQQibn+zl2kJxb4n1cIjwPTMgDvOR1PBEWKG+e1zDMSDwWIQ/2lLVmIGU95QuHPy8ROCCGE6B/61Z27SEufmjNg2Cc+mglW1QCmAhgHwFbuW/bQkifu8zfaGdncWryAiX4BwNaEMMdOM2h7HsLNtRXvuHZBixBCCCFi9dvJnRVfy+3DETKKTGUONcIogDIKNTCMNQoIXABFRazZIPAQACBFg6DZwyADhCEAAMZAJhRcOSYRiiLKnQwAUBhxyiIgch+FVCjvc76a/e/biXdTW+kMxfwoCLdE7SrsPVc8gwHkW2y/AKDb7nYCuhh0GeCzYLzPRG8arDuoaMTfpMyJEEII0T/9D+bIYM2dDu+VAAAAAElFTkSuQmCC" />
    </span>
</a>