<?php

namespace Bitcream\Corradi\Custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use Bitcream\Corradi\Custom\common\models\Offer;

/**
 * OfferSearch represents the model behind the search form of `Bitcream\Corradi\Custom\common\models\Offer`.
 */
class OfferSearch extends Offer
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'supplier_id', 'customer_id', 'tail_lift_required'], 'integer'],
            [['creation_date', 'start_date', 'minimum_value', 'delivery_date', 'delivery_terms', 'return_condition', 'payment_condition', 'payment_notes'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Offer::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'supplier_id' => $this->supplier_id,
            'customer_id' => $this->customer_id,
            'creation_date' => $this->creation_date,
            'tail_lift_required' => $this->tail_lift_required,
        ]);

        $query->andFilterWhere(['like', 'start_date', $this->start_date])
            ->andFilterWhere(['like', 'minimum_value', $this->minimum_value])
            ->andFilterWhere(['like', 'delivery_date', $this->delivery_date])
            ->andFilterWhere(['like', 'delivery_terms', $this->delivery_terms])
            ->andFilterWhere(['like', 'return_condition', $this->return_condition])
            ->andFilterWhere(['like', 'payment_condition', $this->payment_condition])
            ->andFilterWhere(['like', 'payment_notes', $this->payment_notes]);

        return $dataProvider;
    }
}
