<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Field\Date\Date

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="offer-form">

    <?php $form = ActiveForm::begin(); ?>
                <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'supplier_id')->widget(Select2::classname(), [
                'name' => 'supplier_id',
                'class' => 'form-group supplier_id form-control',
                'value' => ArrayHelper::map($suppliers, 'id', function ($supplier) {
                    return $supplier['name'];
                }),
                'id' => 'supplier_id',
                'data' => ArrayHelper::map($suppliers, 'id', function ($supplier) {
                    return $supplier['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select supplier')]
            ])->label(Yii::t('app', 'Supplier'));?>
           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'customer_id')->widget(Select2::classname(), [
                'name' => 'customer_id',
                'class' => 'form-group customer_id form-control',
                'value' => ArrayHelper::map($customers, 'id', function ($customer) {
                    return $customer['name'];
                }),
                'id' => 'customer_id',
                'data' => ArrayHelper::map($customers, 'id', function ($customer) {
                    return $customer['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select customer')]
            ])->label(Yii::t('app', 'Customer'));?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'start_date')->widget(Date::classname()) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'minimum_value')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'delivery_date')->widget(Date::classname()) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'delivery_terms')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'return_condition')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'tail_lift_required')->textInput() ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'payment_condition')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'payment_notes')->textarea(['rows' => 6]) ?>

           </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
