<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%customer}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $business_name
 * @property string|null $vat_id
 * @property string|null $fiscal_code
 * @property string|null $website_url
 * @property string|null $email
 * @property string|null $address
 *
 * @property Offer[] $offers
 * @property PriceList[] $priceLists
 */
class Customer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%customer}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 20],
            [['business_name', 'website_url', 'email', 'address'], 'string', 'max' => 255],
            [['vat_id', 'fiscal_code'], 'string', 'max' => 16],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'business_name' => Yii::t('app', 'Business Name'),
            'vat_id' => Yii::t('app', 'Vat ID'),
            'fiscal_code' => Yii::t('app', 'Fiscal Code'),
            'website_url' => Yii::t('app', 'Website Url'),
            'email' => Yii::t('app', 'Email'),
            'address' => Yii::t('app', 'Address'),
        ];
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['customer_id' => 'id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['customer_id' => 'id']);
    }
}
