<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%offer}}".
 *
 * @property int $id
 * @property int|null $supplier_id
 * @property int|null $customer_id
 * @property string $creation_date
 * @property string|null $start_date
 * @property string|null $minimum_value
 * @property string|null $delivery_date
 * @property string|null $delivery_terms
 * @property string|null $return_condition
 * @property int|null $tail_lift_required
 * @property string|null $payment_condition
 * @property string|null $payment_notes
 *
 * @property Customer $customer
 * @property Supplier $supplier
 */
class Offer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%offer}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['supplier_id', 'customer_id', 'tail_lift_required'], 'integer'],
            [['creation_date'], 'safe'],
            [['payment_notes'], 'string'],
            [['start_date', 'delivery_date'], 'string', 'max' => 20],
            [['minimum_value', 'delivery_terms', 'return_condition', 'payment_condition'], 'string', 'max' => 255],
            [['customer_id'], 'exist', 'skipOnError' => true, 'targetClass' => Customer::className(), 'targetAttribute' => ['customer_id' => 'id']],
            [['supplier_id'], 'exist', 'skipOnError' => true, 'targetClass' => Supplier::className(), 'targetAttribute' => ['supplier_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'supplier_id' => Yii::t('app', 'Supplier ID'),
            'customer_id' => Yii::t('app', 'Customer ID'),
            'creation_date' => Yii::t('app', 'Creation Date'),
            'start_date' => Yii::t('app', 'Start Date'),
            'minimum_value' => Yii::t('app', 'Minimum Value'),
            'delivery_date' => Yii::t('app', 'Delivery Date'),
            'delivery_terms' => Yii::t('app', 'Delivery Terms'),
            'return_condition' => Yii::t('app', 'Return Condition'),
            'tail_lift_required' => Yii::t('app', 'Tail Lift Required'),
            'payment_condition' => Yii::t('app', 'Payment Condition'),
            'payment_notes' => Yii::t('app', 'Payment Notes'),
        ];
    }

    /**
     * Gets query for [[Customer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }

    /**
     * Gets query for [[Supplier]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSupplier()
    {
        return $this->hasOne(Supplier::className(), ['id' => 'supplier_id']);
    }
}
