<?php

use yii\helpers\Html;
use Emberware\Evidia\Model\Datatable\common\models\DataTableCustom;

$attributesPimProducts = [];
$oneProduct = $dataProvider->query->one();
// $oneProduct = [];
if (!empty($oneProduct)) {
    // echo 'product: '.json_encode($model->getOfferProducts()->one()->product->id);
    // echo 'product->pz_per_confezione: '.json_encode($model->getOfferProducts()->one()->product->pz_per_confezione);
    if ($oneProduct->pz_per_confezione) {
        $attributesPimProducts[]= [
            'label' => Yii::t('app', 'pz_per_confezione'),
            'value' => function ($data) {
                return $data->pz_per_confezione;
            },
            'format' => 'text',
        ];
    }
    if ($oneProduct->confezioni_per_collo) {
        $attributesPimProducts[]=[
            'label' => Yii::t('app', 'confezioni_per_collo'),
            'value' => function ($data) {
                return $data->confezioni_per_collo;
            },
        ];
    }
    if ($oneProduct->colli_per_pallet) {
        $attributesPimProducts[]= [
            'label' => Yii::t('app', 'colli_per_pallet'),
            'value' => function ($data) {
                return $data->colli_per_pallet;
            },
        ];
    }
    if ($oneProduct->colli_per_strato) {
        $attributesPimProducts[]= [
            'label' => Yii::t('app', 'colli_per_strato'),
            'value' => function ($data) {
                return $data->colli_per_strato;
            },
        ];
    }
}
$preColumns = [
    ['attribute'=>Yii::t('app', 'Code'),
        'format'=>'raw',
        'value' => function($data)
        {return Html::a($data->codice, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
    ],
    'title',

];
$postColumns = [
    [
        'attribute'=>Yii::t('app', 'Edit'),
        'format'=>'raw',
        'value' => function($data)
        {return Html::a(Yii::t('app', 'Edit'), [Yii::$app->controller->id.'/update','id'=>$data->id], ['class' => 'btn btn-primary']);},
    ],
    [
        'class' => '\yii\grid\ActionColumn',
        'header' => Yii::t('app', 'Actions'),
        'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
    ],
];
$columns = array_merge($preColumns,$attributesPimProducts,$postColumns);

?>
<div class="corda-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'corda-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => $columns,
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>