<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<div class="offer-datatable">
    <?=        Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'offer-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Offer Number'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->id, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                'created_at:date',
                'updated_at:date',
                [
                    'attribute'=>Yii::t('app', 'Supplier'),
                    'format'=>'raw',
                    'value' => 'supplier.business_name',
                ],
                [
                    'attribute'=>Yii::t('app', 'Customer'),
                    'format'=>'raw',
                    'value' => 'customer.business_name',
                ],
                [
                    'attribute'=>Yii::t('app', 'Edit'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a(Yii::t('app', 'Edit'), [Yii::$app->controller->id.'/view','id'=>$data->id], ['class' => 'btn btn-primary']);},
                ],
                [
                    'attribute'=>Yii::t('app', 'View PDF'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a(Yii::t('app', 'Print'), $data->pdfLink, ['class' => 'btn btn-primary', 'target' => '_blank']);},
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ],
                'order' => [[0, 'desc']],
            ],
        ]);
     ?>

</div>