<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use bitcream\pim\custom\common\models\Product;
// use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\ProductValue;
use bitcream\pim\custom\common\models\AttributeValue;
use bitcream\pim\custom\common\models\ProductModelValue;
use yii\helpers\ArrayHelper;
use yii\helpers\Inflector;
/**
 * This is the extended model class for table "{{%product}}".
 */
class CProduct extends Product
{
    // public static $modelSlug = "prodotto_bibo";
    public $pModel = "";

    public function fields(){
        $defaultFields = [
            'id',
            'codice',
            'title',
            'note' => 'short_title',
            // 'description',
            // 'categoria',
            // 'disponibilita_prodotto',
        ];
        $supplier_id = 9; //TODO prendere il supplier dal prodotto
        switch ($supplier_id) {
            case '9':
                $customFields = [
                    'line_id' => 'lineId',
                    'category_id' => 'categoryId',
                    'line' => 'lineaText',
                    'materia_prima' => 'materiaPrimaText',
                    'lavorazione' => 'lavorazioneText',
                    // 'colore',
                    'numero_veli' => 'numeroVeliText',
                    'formato',
                ];
                break;
            default:
                $customFields = [];
                break;
        }
        $attributesPimProducts = [];
        if ($this->pz_per_confezione) $attributesPimProducts[]= 'pz_per_confezione';
        if ($this->confezioni_per_collo) $attributesPimProducts[]= 'confezioni_per_collo';
        if ($this->pz_per_collo) $attributesPimProducts[]= 'pz_per_collo';
        if ($this->colli_per_pallet) $attributesPimProducts[]= 'colli_per_pallet';
        if ($this->colli_per_strato) $attributesPimProducts[]= 'colli_per_strato';

        return array_merge($defaultFields,$customFields,$attributesPimProducts);
    }

    public function getAttributeValueFromSlug(string $slug)
    {
        return (AttributeValue::find()->where(['id' => (int)$this->$slug])->select('title')->scalar())?:'';
    }

    public function getPz_per_collo()
    {
        if(empty($this->pz_per_confezione) || empty($this->confezioni_per_collo)) return;
        return intval($this->pz_per_confezione) * intval($this->confezioni_per_collo);
    }

    public function getLavorazioneText()
    {
        return $this->getAttributeValueFromSlug('lavorazione');
    }

    public function getNumeroVeliText()
    {
        return $this->getAttributeValueFromSlug('numero_veli');
    }

    public function getMateriaPrimaText()
    {
        return $this->getAttributeValueFromSlug('materia_prima');
    }
    public function getcolormodeText()
    {
        return $this->getAttributeValueFromSlug('colormode');
    }

    public function getLineaText()
    {
        return self::find()->where(['id' => (int)$this->linea])->select('title')->scalar();
    }

    public function getLineId()
    {
        return [(int)$this->linea];
    }

    public function getCategoryId()
    {
        return ArrayHelper::getColumn($this->categoria, function ($categoryId) {
            return (int)$categoryId;});
    }

    public function setProductModel()
    {
        static::$modelSlug = $this->pModel;
        parent::setProductModel();
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public static function findIdByCode(string|array $code)
    {
        $productIds = ProductValue::find()
            ->where([
                'attribute_id' => 1,    //codice
                'value' => $code,
            ])
            ->select('product_id')->column();
        return $productIds;
    }
    public static function findByCode(String $code)
    {
        return self::findOne(self::findIdByCode($code));
    }

    public function getChildIds(array $selectedProductIdsFilter = null)
    {
        $categoryAttributeId = ProductModelValue::find()
            ->where([
                'product_model_id' => $this->product_model_id,])
            ->select([
                'attribute_id'])
            ->scalar();
        $childIdsQuery = ProductValue::find()
            ->where(['attribute_id' => $categoryAttributeId]);
        $childIdsQuery->andWhere(['like', 'value', '%"'.(string)$this->id.'"%', false]);
        $childIdsQuery->andFilterWhere(['product_id' => $selectedProductIdsFilter]);
        $childIds = $childIdsQuery
            ->select([
                'product_id'])
            ->column();
        return $childIds;
    }

    public function getChildProducts(array $selectedProductIdsFilter = null)
    {
        $childIds = $this->getChildIds($selectedProductIdsFilter);
        if(empty($childIds)) return self::find()->where('0=1');
        return self::find()->where(['id' => $childIds]);
    }

    public static function findSelectedChildProducts(int $categoryId, array $selectedProductIdsFilter = null)
    {
        $category = self::findOne(['id' => $categoryId]);
        if(empty($category)) return [];
        $selectedChild = $category->getChildProducts($selectedProductIdsFilter)->all();
        ArrayHelper::multisort($selectedChild, 'codice');
        return $selectedChild;
    }


    public static function findCategoriesChildProducts(array $categoriesIds, array $selectedProductIdsFilter = null)
    {
        $categories = self::findall(['id' => $categoriesIds]);
        if(empty($categories)) return [];
        $selectedChild=[];
        foreach ($categories as $category) {
            $categoriesChild = $category->getChildProducts($selectedProductIdsFilter)->all();
            $selectedChild = array_merge($selectedChild, $categoriesChild);
        }
        ArrayHelper::multisort($selectedChild, 'codice');
        return $selectedChild;
    }

    public static function find(){
        return parent::find()->andWhere([
            'status' => 30, //prodotti non cancellati
        ]);
    }

}