<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%customer}}".
 *
 * @property int $id
 * @property string|null $business_name
 * @property string|null $vat_id
 * @property string|null $fiscal_code
 * @property string|null $website_url
 * @property string|null $email
 * @property string|null $address
 * @property string|null $postal_code
 * @property string|null $city
 * @property string|null $province
 * @property int|null $customer_category_id
 * @property int|null $customer_association_id
 * @property int|null $customer_channel_id
 * @property string|null $bank_account_address
 * @property string|null $pec
 * @property string|null $sdi_code
 * @property int $agent_id
 *
 * @property Agent $agent
 * @property CustomerAssociation $customerAssociation
 * @property CustomerCategory $customerCategory
 * @property CustomerChannel $customerChannel
 * @property CustomerSupplier[] $customerSuppliers
 * @property Offer[] $offers
 * @property PriceListCustomer[] $priceListCustomers
 * @property PriceList[] $priceLists
 * @property Supplier[] $suppliers
 */
class Customer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%customer}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_category_id', 'customer_association_id', 'customer_channel_id', 'agent_id'], 'integer'],
            [['business_name', 'website_url', 'email', 'address', 'postal_code', 'city', 'province', 'bank_account_address', 'pec', 'sdi_code'], 'string', 'max' => 255],
            [['vat_id', 'fiscal_code'], 'string', 'max' => 16],
            [['agent_id'], 'exist', 'skipOnError' => true, 'targetClass' => Agent::className(), 'targetAttribute' => ['agent_id' => 'id']],
            [['customer_association_id'], 'exist', 'skipOnError' => true, 'targetClass' => CustomerAssociation::className(), 'targetAttribute' => ['customer_association_id' => 'id']],
            [['customer_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => CustomerCategory::className(), 'targetAttribute' => ['customer_category_id' => 'id']],
            [['customer_channel_id'], 'exist', 'skipOnError' => true, 'targetClass' => CustomerChannel::className(), 'targetAttribute' => ['customer_channel_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'business_name' => Yii::t('app', 'Business Name'),
            'vat_id' => Yii::t('app', 'Vat ID'),
            'fiscal_code' => Yii::t('app', 'Fiscal Code'),
            'website_url' => Yii::t('app', 'Website Url'),
            'email' => Yii::t('app', 'Email'),
            'address' => Yii::t('app', 'Address'),
            'postal_code' => Yii::t('app', 'Postal Code'),
            'city' => Yii::t('app', 'City'),
            'province' => Yii::t('app', 'Province'),
            'customer_category_id' => Yii::t('app', 'Customer Category ID'),
            'customer_association_id' => Yii::t('app', 'Customer Association ID'),
            'customer_channel_id' => Yii::t('app', 'Customer Channel ID'),
            'bank_account_address' => Yii::t('app', 'Bank Account Address'),
            'pec' => Yii::t('app', 'Pec'),
            'sdi_code' => Yii::t('app', 'Sdi Code'),
            'agent_id' => Yii::t('app', 'Agent ID'),
        ];
    }

    /**
     * Gets query for [[Agent]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAgent()
    {
        return $this->hasOne(Agent::className(), ['id' => 'agent_id']);
    }

    /**
     * Gets query for [[CustomerAssociation]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerAssociation()
    {
        return $this->hasOne(CustomerAssociation::className(), ['id' => 'customer_association_id']);
    }

    /**
     * Gets query for [[CustomerCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCategory()
    {
        return $this->hasOne(CustomerCategory::className(), ['id' => 'customer_category_id']);
    }

    /**
     * Gets query for [[CustomerChannel]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerChannel()
    {
        return $this->hasOne(CustomerChannel::className(), ['id' => 'customer_channel_id']);
    }

    /**
     * Gets query for [[CustomerSuppliers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerSuppliers()
    {
        return $this->hasMany(CustomerSupplier::className(), ['customer_id' => 'id']);
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['customer_id' => 'id']);
    }

    /**
     * Gets query for [[PriceListCustomers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceListCustomers()
    {
        return $this->hasMany(PriceListCustomer::className(), ['customer_id' => 'id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['id' => 'price_list_id'])->via('priceListCustomers');
    }

    /**
     * Gets query for [[Suppliers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSuppliers()
    {
        return $this->hasMany(Supplier::className(), ['id' => 'supplier_id'])->via('customerSuppliers');
    }
}
