<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%price_list_product_price}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%price_list}}`
 */
class M221010022449CreatePriceListProductPriceTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%price_list_product_price}}', [
            'id' => $this->primaryKey(),
            'price_list_id' => $this->integer()->notNull(),
            'product_code' => $this->string(20)->notNull(),
            'price' => $this->float()->notNull(),
        ]);

        // creates index for column `price_list_id`
        $this->createIndex(
            '{{%idx-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}',
            'price_list_id',
            'product_code',
            'price',
        );

        // add foreign key for table `{{%price_list}}`
        $this->addForeignKey(
            '{{%fk-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}',
            'price_list_id',
            '{{%price_list}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%price_list}}`
        $this->dropForeignKey(
            '{{%fk-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}'
        );

        // drops index for column `price_list_id`
        $this->dropIndex(
            '{{%idx-price_list_product_price-price_list_id}}',
            '{{%price_list_product_price}}'
        );

        $this->dropTable('{{%price_list_product_price}}');
    }
}
