<?php

namespace Bitcream\Corradi\Custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use Bitcream\Corradi\Custom\common\models\Customer;

/**
 * CustomerSearch represents the model behind the search form of `Bitcream\Corradi\Custom\common\models\Customer`.
 */
class CustomerSearch extends Customer
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'customer_category_id', 'customer_association_id', 'customer_channel_id', 'agent_id'], 'integer'],
            [['business_name', 'vat_id', 'fiscal_code', 'website_url', 'email', 'address', 'postal_code', 'city', 'province', 'bank_account_address', 'pec', 'sdi_code'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Customer::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'customer_category_id' => $this->customer_category_id,
            'customer_association_id' => $this->customer_association_id,
            'customer_channel_id' => $this->customer_channel_id,
            'agent_id' => $this->agent_id,
        ]);

        $query->andFilterWhere(['like', 'business_name', $this->business_name])
            ->andFilterWhere(['like', 'vat_id', $this->vat_id])
            ->andFilterWhere(['like', 'fiscal_code', $this->fiscal_code])
            ->andFilterWhere(['like', 'website_url', $this->website_url])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'address', $this->address])
            ->andFilterWhere(['like', 'postal_code', $this->postal_code])
            ->andFilterWhere(['like', 'city', $this->city])
            ->andFilterWhere(['like', 'province', $this->province])
            ->andFilterWhere(['like', 'bank_account_address', $this->bank_account_address])
            ->andFilterWhere(['like', 'pec', $this->pec])
            ->andFilterWhere(['like', 'sdi_code', $this->sdi_code]);

        return $dataProvider;
    }
}
