<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%offer_price_list}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%offer}}`
 * - `{{%price_list}}`
 */
class M221013074752CreateJunctionTableForOfferAndPriceListTables extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%offer_price_list}}', [
            'offer_id' => $this->integer(),
            'price_list_id' => $this->integer(),
            'PRIMARY KEY(offer_id, price_list_id)',
        ]);

        // creates index for column `offer_id`
        $this->createIndex(
            '{{%idx-offer_price_list-offer_id}}',
            '{{%offer_price_list}}',
            'offer_id'
        );

        // add foreign key for table `{{%offer}}`
        $this->addForeignKey(
            '{{%fk-offer_price_list-offer_id}}',
            '{{%offer_price_list}}',
            'offer_id',
            '{{%offer}}',
            'id',
            'CASCADE'
        );

        // creates index for column `price_list_id`
        $this->createIndex(
            '{{%idx-offer_price_list-price_list_id}}',
            '{{%offer_price_list}}',
            'price_list_id'
        );

        // add foreign key for table `{{%price_list}}`
        $this->addForeignKey(
            '{{%fk-offer_price_list-price_list_id}}',
            '{{%offer_price_list}}',
            'price_list_id',
            '{{%price_list}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%offer}}`
        $this->dropForeignKey(
            '{{%fk-offer_price_list-offer_id}}',
            '{{%offer_price_list}}'
        );

        // drops index for column `offer_id`
        $this->dropIndex(
            '{{%idx-offer_price_list-offer_id}}',
            '{{%offer_price_list}}'
        );

        // drops foreign key for table `{{%price_list}}`
        $this->dropForeignKey(
            '{{%fk-offer_price_list-price_list_id}}',
            '{{%offer_price_list}}'
        );

        // drops index for column `price_list_id`
        $this->dropIndex(
            '{{%idx-offer_price_list-price_list_id}}',
            '{{%offer_price_list}}'
        );

        $this->dropTable('{{%offer_price_list}}');
    }
}
