<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%price_list_customer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%price_list}}`
 * - `{{%customer}}`
 */
class M221013074856CreateJunctionTableForPriceListAndCustomerTables extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%price_list_customer}}', [
            'price_list_id' => $this->integer(),
            'customer_id' => $this->integer(),
            'PRIMARY KEY(price_list_id, customer_id)',
        ]);

        // creates index for column `price_list_id`
        $this->createIndex(
            '{{%idx-price_list_customer-price_list_id}}',
            '{{%price_list_customer}}',
            'price_list_id'
        );

        // add foreign key for table `{{%price_list}}`
        $this->addForeignKey(
            '{{%fk-price_list_customer-price_list_id}}',
            '{{%price_list_customer}}',
            'price_list_id',
            '{{%price_list}}',
            'id',
            'CASCADE'
        );

        // creates index for column `customer_id`
        $this->createIndex(
            '{{%idx-price_list_customer-customer_id}}',
            '{{%price_list_customer}}',
            'customer_id'
        );

        // add foreign key for table `{{%customer}}`
        $this->addForeignKey(
            '{{%fk-price_list_customer-customer_id}}',
            '{{%price_list_customer}}',
            'customer_id',
            '{{%customer}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%price_list}}`
        $this->dropForeignKey(
            '{{%fk-price_list_customer-price_list_id}}',
            '{{%price_list_customer}}'
        );

        // drops index for column `price_list_id`
        $this->dropIndex(
            '{{%idx-price_list_customer-price_list_id}}',
            '{{%price_list_customer}}'
        );

        // drops foreign key for table `{{%customer}}`
        $this->dropForeignKey(
            '{{%fk-price_list_customer-customer_id}}',
            '{{%price_list_customer}}'
        );

        // drops index for column `customer_id`
        $this->dropIndex(
            '{{%idx-price_list_customer-customer_id}}',
            '{{%price_list_customer}}'
        );

        $this->dropTable('{{%price_list_customer}}');
    }
}
