<?php

namespace Bitcream\Corradi\Custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use Bitcream\Corradi\Custom\common\models\Offer;

/**
 * OfferSearch represents the model behind the search form of `Bitcream\Corradi\Custom\common\models\Offer`.
 */
class OfferSearch extends Offer
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'supplier_id', 'customer_id', 'return_condition_id', 'payment_condition_id', 'agent_id'], 'integer'],
            [['start_date', 'minimum_value', 'payment_notes', 'created_at', 'end_date', 'tail_lift_notes', 'delivery_terms_notes'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Offer::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'supplier_id' => $this->supplier_id,
            'customer_id' => $this->customer_id,
            'created_at' => $this->created_at,
            'end_date' => $this->end_date,
            'return_condition_id' => $this->return_condition_id,
            'payment_condition_id' => $this->payment_condition_id,
            'agent_id' => $this->agent_id,
        ]);

        $query->andFilterWhere(['like', 'start_date', $this->start_date])
            ->andFilterWhere(['like', 'minimum_value', $this->minimum_value])
            ->andFilterWhere(['like', 'payment_notes', $this->payment_notes])
            ->andFilterWhere(['like', 'tail_lift_notes', $this->tail_lift_notes])
            ->andFilterWhere(['like', 'delivery_terms_notes', $this->delivery_terms_notes]);

        return $dataProvider;
    }
}
