<?php

namespace Bitcream\Corradi\Custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use Bitcream\Corradi\Custom\common\models\PriceListProductPrice;

/**
 * PriceListProductPriceSearch represents the model behind the search form of `Bitcream\Corradi\Custom\common\models\PriceListProductPrice`.
 */
class PriceListProductPriceSearch extends PriceListProductPrice
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'price_list_id'], 'integer'],
            [['product_code'], 'safe'],
            [['price'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PriceListProductPrice::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'price_list_id' => $this->price_list_id,
            'price' => $this->price,
        ]);

        $query->andFilterWhere(['like', 'product_code', $this->product_code]);

        return $dataProvider;
    }
}
