<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<div class="price-list-datatable">
    <?=        Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'price-list-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                'supplier.business_name:text:Supplier',
                'customer.business_name:text:Customer',
                'is_active:boolean',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>