<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Field\SwitchInput\SwitchInput;


/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\PriceList */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="price-list-form">

    <?php $form = ActiveForm::begin(); ?>
                <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
           <?= $form->field($model, 'supplier_id')->widget(Select2::classname(), [
                'name' => 'supplier_id',
                'class' => 'form-group supplier_id form-control',
                'value' => ArrayHelper::map($suppliers, 'id', function ($supplier) {
                    return $supplier['business_name'];
                }),
                'id' => 'supplier_id',
                'data' => ArrayHelper::map($suppliers, 'id', function ($supplier) {
                    return $supplier['business_name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select supplier')],
            ])->label(Yii::t('app', 'Supplier'));?>
           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
           <?= $form->field($model, 'customer_id')->widget(Select2::classname(), [
                'name' => 'customer_id',
                'class' => 'form-group customer_id form-control',
                'value' => ArrayHelper::map($customers, 'id', function ($customer) {
                    return $customer['business_name'];
                }),
                'id' => 'customer_id',
                'data' => ArrayHelper::map($customers, 'id', function ($customer) {
                    return $customer['business_name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select customer')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Customer'));?>
           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
           <?= $form->field($model, 'is_active')->widget(SwitchInput::class);?>
           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
           <?=$form->field($model, 'csv')->widget(floor12\files\components\FileInputWidget::class) ?>
            <input type="hidden" name="csv" value="<?=($model->csv)? $model->csv->href: ""?>">
           </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
