<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
/**
 * This is the model common class for table "offer".
 */
class Offer extends base\Offer
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find();
        // ->where(['status' => 30]);
    }

    public function fields(){
        return [
            'id',
            'selectedProducts',
            'filters',
            'header',
            'availableProducts',
        ];
    }

    /**
     * Get Supplier Name
     */
    public function getSupplierName(){
        return $this->supplier->name;
    }
    /**
     * Get Customer Name
     */
    public function getCustomerName(){
        return $this->customer->name;
    }

    public function getSelectedProducts(){
        return [1,5];
    }

    public function getFilters(){
        return [
            // [
            //     "name" => "Categorie",
            //     "key" => "category",
            //     "items" => [
            //         [
            //             "id" => 1,
            //             "slug" => "category-1",
            //             "name" => "Categoria 1",
            //         ],
            //         [
            //             "id" => 2,
            //             "slug" => "category-2",
            //             "name" => "Categoria 2",
            //         ],
            //     ],
            // ],
            [
                "name" => "Linee",
                "key" => "linea",
                "items" => [
                    [
                        "id" => "3",
                        "slug" => "line-3",
                        "name" => "Prime",
                    ],
                    [
                        "id" => "31",
                        "slug" => "line-31",
                        "name" => "Linea 31",
                    ],
                    [
                        "id" => "30",
                        "slug" => "line-30",
                        "name" => "Linea 30",
                    ],
                ],
            ],
        ];
    }

    public function getHeader(){
        return [
            [
                "name" => "codice",
                "keys" => ["codice"],
                "template" => "default" // default || description || price || percentage
            ],
            [
                "name" => "alert",
                "keys" => ["disponibilita_prodotto"],
                "template" => "alert",
            ],
            [
                "name" => "nome",
                "keys" => [
                    "title",
                    "description",
                ],
                "template" => "description",
            ],
            [
                "name" => "linea",
                "keys" => [
                    "linea",
                ],
                "template" => "linea",
            ],
        ];
    }

    public function getAvailableProducts(){
        return CProduct::findAll(["id" => [188, 278, 233, 149, 42, 117]]);
    }



}
