<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%agent}}".
 *
 * @property int $id
 * @property string $name
 * @property string $surname
 * @property string $email
 * @property string|null $phone_number_1
 * @property string|null $phone_number_2
 *
 * @property Offer[] $offers
 */
class Agent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%agent}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'surname', 'email'], 'required'],
            [['name', 'surname'], 'string', 'max' => 100],
            [['email'], 'string', 'max' => 255],
            [['phone_number_1', 'phone_number_2'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'surname' => Yii::t('app', 'Surname'),
            'email' => Yii::t('app', 'Email'),
            'phone_number_1' => Yii::t('app', 'Phone Number  1'),
            'phone_number_2' => Yii::t('app', 'Phone Number  2'),
        ];
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['agent_id' => 'id']);
    }
}
