<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%customer}}".
 *
 * @property int $id
 * @property string|null $business_name
 * @property string|null $vat_id
 * @property string|null $fiscal_code
 * @property string|null $website_url
 * @property string|null $email
 * @property string|null $address
 * @property string|null $postal_code
 * @property string|null $city
 * @property string|null $province
 * @property int|null $customer_category_id
 * @property int|null $customer_association_id
 * @property int|null $customer_channel_id
 *
 * @property CustomerAssociation $customerAssociation
 * @property CustomerCategory $customerCategory
 * @property CustomerChannel $customerChannel
 * @property Offer[] $offers
 * @property PriceList[] $priceLists
 */
class Customer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%customer}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_category_id', 'customer_association_id', 'customer_channel_id'], 'integer'],
            [['business_name', 'website_url', 'email', 'address', 'postal_code', 'city', 'province'], 'string', 'max' => 255],
            [['vat_id', 'fiscal_code'], 'string', 'max' => 16],
            [['customer_association_id'], 'exist', 'skipOnError' => true, 'targetClass' => CustomerAssociation::className(), 'targetAttribute' => ['customer_association_id' => 'id']],
            [['customer_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => CustomerCategory::className(), 'targetAttribute' => ['customer_category_id' => 'id']],
            [['customer_channel_id'], 'exist', 'skipOnError' => true, 'targetClass' => CustomerChannel::className(), 'targetAttribute' => ['customer_channel_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'business_name' => Yii::t('app', 'Business Name'),
            'vat_id' => Yii::t('app', 'Vat ID'),
            'fiscal_code' => Yii::t('app', 'Fiscal Code'),
            'website_url' => Yii::t('app', 'Website Url'),
            'email' => Yii::t('app', 'Email'),
            'address' => Yii::t('app', 'Address'),
            'postal_code' => Yii::t('app', 'Postal Code'),
            'city' => Yii::t('app', 'City'),
            'province' => Yii::t('app', 'Province'),
            'customer_category_id' => Yii::t('app', 'Customer Category ID'),
            'customer_association_id' => Yii::t('app', 'Customer Association ID'),
            'customer_channel_id' => Yii::t('app', 'Customer Channel ID'),
        ];
    }

    /**
     * Gets query for [[CustomerAssociation]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerAssociation()
    {
        return $this->hasOne(CustomerAssociation::className(), ['id' => 'customer_association_id']);
    }

    /**
     * Gets query for [[CustomerCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCategory()
    {
        return $this->hasOne(CustomerCategory::className(), ['id' => 'customer_category_id']);
    }

    /**
     * Gets query for [[CustomerChannel]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerChannel()
    {
        return $this->hasOne(CustomerChannel::className(), ['id' => 'customer_channel_id']);
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['customer_id' => 'id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['customer_id' => 'id']);
    }
}
