<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%supplier}}".
 *
 * @property int $id
 * @property string|null $business_name
 * @property string|null $vat_id
 * @property string|null $fiscal_code
 * @property string|null $website_url
 * @property string|null $email
 * @property string|null $address
 * @property string|null $bank_account_address
 * @property string|null $postal_code
 * @property string|null $city
 * @property string|null $province
 *
 * @property Offer[] $offers
 * @property PriceList[] $priceLists
 */
class Supplier extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%supplier}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['business_name', 'website_url', 'email', 'address', 'bank_account_address', 'postal_code', 'city', 'province'], 'string', 'max' => 255],
            [['vat_id', 'fiscal_code'], 'string', 'max' => 16],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'business_name' => Yii::t('app', 'Business Name'),
            'vat_id' => Yii::t('app', 'Vat ID'),
            'fiscal_code' => Yii::t('app', 'Fiscal Code'),
            'website_url' => Yii::t('app', 'Website Url'),
            'email' => Yii::t('app', 'Email'),
            'address' => Yii::t('app', 'Address'),
            'bank_account_address' => Yii::t('app', 'Bank Account Address'),
            'postal_code' => Yii::t('app', 'Postal Code'),
            'city' => Yii::t('app', 'City'),
            'province' => Yii::t('app', 'Province'),
        ];
    }

    /**
     * Gets query for [[Offers]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOffers()
    {
        return $this->hasMany(Offer::className(), ['supplier_id' => 'id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['supplier_id' => 'id']);
    }
}
