<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<div class="customer-supplier-datatable">
    <?=        Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'customer-supplier-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Customer-supplier'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->customer->business_name.' - '.$data->supplier->business_name, [Yii::$app->controller->id.'/view','customer_id'=>$data->customer_id, 'supplier_id'=>$data->supplier_id]);}
                ],
                'customer.business_name' => 'Customer Name',
                'supplier.business_name' => 'Supplier Name',
                'paymentCondition.name' => 'Payment Condition',
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>