<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Field\Date\Date;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="offer-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class='row'>
        <div class='col-md-6 col-xs-12'>
        <?= $form->field($model, 'productsCodes')->widget(Select2::classname(), [
            'name' => 'productsCodes',
            'class' => 'form-group productsIds form-control',
            // 'value' => ArrayHelper::map($model->availableProducts, 'codice', function ($product) {
            //     return $product['codice'].' - '.$product['title'];
            // }),
            'id' => 'productsCodes',
            'data' => ArrayHelper::map($model->availableProducts, 'codice', function ($product) {
                return $product['codice'].' - '.$product['title'];
            }),
            'options' => ['multiple' => true, 'placeholder' => Yii::t('app', 'Select products')],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ])->label(Yii::t('app', 'Products'));?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
