<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */

?>
    <h3><?= Html::encode(Yii::t('app', 'Header')) ?></h3>
    <div class='row'>
           <div class='col-md-8 col-xs-12'>
           <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    [
                        'label' => Yii::t('app', 'Customer'),
                        'value' => ($model->customer?->business_name)?:'',
                    ],
                    'your_kind_attention',
                    [
                        'label' => Yii::t('app', 'Supplier'),
                        'value' => ($model->supplier?->business_name)?:'',
                    ],
                    [
                        'label' => Yii::t('app', 'Agent'),
                        'value' => ($model->agent?->name)?:'',
                    ],
                    'start_date:datetime',
                    'end_date:datetime',
                ],
            ]) ?>
           </div>
           <div class='col-md-4 col-xs-12'>
           <?= Html::a(Yii::t('app', 'Update Header'), ['update-header', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
           </div>
        </div>