<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */

?>
<h3><?= Html::encode(Yii::t('app', 'Price Lists')) ?></h3>
<div class='row'>
    <div class='col-md-8 col-xs-12'>
    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            [
                'label' => Yii::t('app', 'Price Lists'),
                'value' => function($data)
                    {return implode(', ', ArrayHelper::getColumn($data->priceLists, function ($priceList) {
                        return $priceList['name'];}));}
            ],
        ],
    ]) ?>
    </div>
    <div class='col-md-4 col-xs-12'>
    <?= Html::a(Yii::t('app', 'Update Price lists'), ['update-price-list', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>

    </div>
</div>