<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
use bitcream\pim\custom\common\models\ProductModel;
/**
 * This is the model common class for table "supplier".
 */
class Supplier extends base\Supplier
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find();
        // ->where(['status' => 30]);
    }

    public function fields()
    {
        return [
            'name' => 'business_name',
            'logo' => 'logoUrl',
            'description' => 'fullDescription',
            'mainColor',
            'certifications',
        ];
    }

    public function getFullDescription() //TODO prendere FullDescription fornitore dinamicamente dal fornitore
    {
        return '<p><strong>INDUSTRIE CELTEX S.p.a.</strong></p><p> SEDE OPERATIVA & LOGISTICA: Via dei Sandroni, 22 - 55011 Altopascio(LU)</p>';
    }

    public function getLogoUrl() //TODO prendere logo dinamicamente dal fornitore
    {
        return 'https://www.industrieceltex.com/App_Skins/Sito/images/LogoRetina.png';
    }

    public function getMainColor() //TODO prendere main color dinamicamente dal fornitore
    {
        return '#96bd20';
    }

    public function getCertifications() //TODO prendere certificati dinamicamente dal fornitore
    {
        return [
            [
                'name' => 'PEFC',
                'icon' => 'https://www.arix.it/wp-content/uploads/2022/08/pefc-label-pefc18-31-1280-marchio-fuori-prodotto-orizzontale-200x142.png',
            ],
            [
                'name' => 'ISO 45001',
                'icon' => 'https://www.arix.it/wp-content/uploads/2022/02/iso_45501.jpg',
            ],
            [
                'name' => 'ISO 9001',
                'icon' => 'https://www.arix.it/wp-content/uploads/2022/02/certified-img.png',
            ],
        ];
    }

    public function getPdfHeader()
    {
        $preHeader = [
            [
                'name' => 'Codice',
                'keys' => ['product.codice'],
                'template' => 'code',
            ],
            [
                'name' => 'Descrizione',
                'keys' => ['product.title','product.description'],
                'template' => 'description',
            ],
        ];
        switch ($this->id) { //TODO gestire gli header per altri fornitori
            case '1': //celtex //TODO prendere le configurazioni da db o config
                $customHeader = [
                    [
                        'name' => 'Linea',
                        'keys' => ['product.line_id'], //linea_celtex
                        'template' => 'line',
                    ],
                    [
                        'name' => 'Materia prima',
                        'keys' => ['product.materia_prima'],
                        'template' => 'default',
                    ],
                    [
                        'name' => 'Lavorazione',
                        'keys' => ['product.lavorazione'],
                        'template' => 'default',
                    ],
                    [
                        'name' => 'Numero Veli',
                        'keys' => ['product.numero_veli'],
                        'template' => 'default',
                    ],
                    [
                        'name' => 'Formato',
                        'keys' => ['product.formato'],
                        'template' => 'default',
                    ],
                ];
                break;

            default:
                $customHeader = [];
                break;
        }
        $postHeader = [
            [
                'name' => 'Sc 1',
                'keys' => ['offerData.discount_1'],
                'template' => 'percentage',
            ],
            [
                'name' => 'Sc 2',
                'keys' => ['offerData.discount_2'],
                'template' => 'percentage',
            ],
            [
                'name' => 'Sc 3',
                'keys' => ['offerData.discount_3'],
                'template' => 'percentage',
            ],
            [
                'name' => 'Sc 4',
                'keys' => ['offerData.discount_4'],
                'template' => 'percentage',
            ],
            // [
            //     'name' => 'Sconto 5',
            //     'keys' => ['offerData.discount_5'],
            //     'template' => 'percentage',
            // ],
            // [
            //     'name' => 'Sconto 6',
            //     'keys' => ['offerData.discount_6'],
            //     'template' => 'percentage',
            // ],
            [
                'name' => '€ collo per listino',
                'keys' => ['offerData.net_price'],
                'template' => 'price',
            ],
            [
                'name' => 'sc. merce collo x plt',
                'keys' => ['offerData.merchandise_discount'],
                'template' => 'percentage',
            ],
            // [
            //     'name' => '€ collo',
            //     'keys' => ['discounts.sc-6'],
            //     'template' => 'percentage',
            // ],
        ];
        return array_merge($preHeader, $customHeader, $postHeader);
    }

    public function getCategoryProductModelSlug()
    {
        switch ($this->id) {
            case '1':   //celtex //TODO prendere dinamicamente dalla categoria
                return 'categoria_celtex';
                break;
            case '28':   //Bettari
                return 'categoria_bettari';
                break;
            case '26':   //bibo
                return 'categoria_bibo';
                break;
            case '22':   //Ceplast
                return 'categoria_ceplast';
                break;
            case '24':   //Mechanotools / Icont
                return 'categoria_icont';
                break;
            default:
                return false;
                break;
        }
    }

    public function getCategories()
    {
        return ProductModel::findOne(['slug' => $this->getCategoryProductModelSlug()])?->getProducts();
    }

    public function getLineProductModelSlug()
    {
        switch ($this->id) {
            case '1':   //celtex //TODO prendere linee dinamicamente
                return 'linea_celtex';
                break;
            default:
                return false;
                break;
        }
    }

    public function getDivisionProductModelSlug()
    {
        switch ($this->id) {
            case '1':   //celtex //TODO prendere divisioni dinamicamente dalla categoria
                return 'divisione_celtex';
                break;
            case '28':   //Bettari
                return 'divisione_bettari';
                break;
            case '26':   //bibo
                return 'divisione_bibo';
                break;
            case '22':   //Ceplast
                return 'divisione_ceplast';
                break;
            case '24':   //Mechanotools / Icont
                return 'divisione_icont';
                break;
            default:
                return false;
                break;
        }
    }

    public function getSaleConditions()
    {
        $saleConditions= [];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['minimum_value'],
                'content' => $this->minimum_value,
            ];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['free_port'],
                'content' => $this->free_port,
            ];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['free_port_contribution'],
                'content' => $this->free_port_contribution,
            ];
        if (!empty($this->minimum_value))
            $saleConditions[] = [
                'label' => $this->attributeLabels()['delivery_time'],
                'content' => $this->delivery_time,
            ];

        return $saleConditions;
    }

}
