<?php

namespace Bitcream\Corradi\Custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use Bitcream\Corradi\Custom\common\models\OfferProducts;

/**
 * OfferProductsSearch represents the model behind the search form of `Bitcream\Corradi\Custom\common\models\OfferProducts`.
 */
class OfferProductsSearch extends OfferProducts
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'offer_id', 'show_avalibility'], 'integer'],
            [['product_code', 'notes'], 'safe'],
            [['discount_1', 'dscount_2', 'discount_3', 'discount_4', 'discount_5', 'net_price', 'merchandise_discount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = OfferProducts::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'offer_id' => $this->offer_id,
            'show_avalibility' => $this->show_avalibility,
            'discount_1' => $this->discount_1,
            'dscount_2' => $this->dscount_2,
            'discount_3' => $this->discount_3,
            'discount_4' => $this->discount_4,
            'discount_5' => $this->discount_5,
            'net_price' => $this->net_price,
            'merchandise_discount' => $this->merchandise_discount,
        ]);

        $query->andFilterWhere(['like', 'product_code', $this->product_code])
            ->andFilterWhere(['like', 'notes', $this->notes]);

        return $dataProvider;
    }
}
