<?php

namespace Bitcream\Corradi\Custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use Bitcream\Corradi\Custom\common\models\ReturnCondition;

/**
 * ReturnConditionSearch represents the model behind the search form of `Bitcream\Corradi\Custom\common\models\ReturnCondition`.
 */
class ReturnConditionSearch extends ReturnCondition
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'is_bank_payment'], 'integer'],
            [['name', 'discount'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ReturnCondition::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        
        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'is_bank_payment' => $this->is_bank_payment,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'discount', $this->discount]);

        return $dataProvider;
    }
}
