<?php

use yii\helpers\Html;
// use yii\widgets\ActiveForm;
use kartik\form\ActiveForm;
use kartik\builder\TabularForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Field\Date\Date;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="offer-form">

    <?php $form = ActiveForm::begin(); ?>

    <?php //TODO nella creazione dell'offerta verrà chiesto quali categorie mostrare ?>


    <?= Html::a(Yii::t('app', 'Add/remove products'), [Yii::$app->controller->id.'/add-products','id'=>$model->id],['class' => 'btn btn-primary']) ?>

    <?php
    echo TabularForm::widget([
        'dataProvider'=> $model->productsDataProvider,
        'form'=>$form,
        'attributes'=>[
            'id'=>[ // primary key attribute
                'type'=>TabularForm::INPUT_HIDDEN,
                'columnOptions'=>['hidden'=>true]
            ],
            'product_code'=>[
                'type' => TabularForm::INPUT_STATIC,
            ],
            [
                // 'label' => false, //Yii::t('app', 'Name'),
                'value' => function($data){return $data->product->title;},
                'type' => TabularForm::INPUT_STATIC,
            ],
            // [
            //     'label' => Yii::t('app', 'availability'),
            //     'value' => function($data){
            //         $value = (!empty($data->product->disponibilita_prodotto))?:Yii::t('app', 'Available');
            //         return $value;},
            //     'type' => TabularForm::INPUT_STATIC,
            // ],
            'show_avalibility'=>[   //TODO mostrare disponibilità del prodotto se non disponibile mostrare switch
                // 'type'=>TabularForm::INPUT_WIDGET,
                'type' => function($data) {
                    $value = (!empty($data->product->disponibilita_prodotto))?TabularForm::INPUT_WIDGET:TabularForm::INPUT_STATIC;
                    return $value;},
                'widgetClass'=> \Emberware\Evidia\Field\SwitchInput\SwitchInput::class,
                'value' => function($data){
                    $value = (!empty($data->product->disponibilita_prodotto))?:Yii::t('app', 'Available');
                    return $value;},

                // 'prepend ' => 'test',
                // 'prepend ' => function($data){
                //     $value = (!empty($data->product->disponibilita_prodotto))?Yii::t('app', 'Not Available'):Yii::t('app', 'Available');
                //     // $value = 'test';
                //     return $value;},
            ],

            [
                'label' => Yii::t('app', 'pz_per_confezione'),
                'value' => function($data){return $data->product->pz_per_confezione;},
                'type' => TabularForm::INPUT_STATIC,
            ],
            [
                'label' => Yii::t('app', 'confezioni_per_collo'),
                'value' => function($data){return $data->product->confezioni_per_collo;},
                'type' => TabularForm::INPUT_STATIC,
            ],
            [
                'label' => Yii::t('app', 'colli_per_pallet'),
                'value' => function($data){return $data->product->colli_per_pallet;},
                'type' => TabularForm::INPUT_STATIC,
            ],
            // [
            //     'label' => Yii::t('app', 'colli_per_strato'),
            //     'value' => function($data){return $data->product->colli_per_strato;},
            //     'type' => TabularForm::INPUT_STATIC,
            // ],

            'net_price'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
            'discount_1'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
            'dscount_2'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
            'discount_3'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
            'discount_4'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
            'merchandise_discount'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
            'notes'=>[
                'type' => TabularForm::INPUT_TEXT,
            ],
        ],
        'gridSettings'=>['condensed'=>true],
        'actionColumn' => false,
        'checkboxColumn' => false,

    ]);
    ?>


    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
