<?php

use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */

$this->title = Yii::t('app', 'Update Offer: {name}', [
    'name' => $model->id,
]);
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Offers'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Update');
?>
<div class="offer-update">
    <?=  $this->render('_breadcrumb') ?>
    <h1><?= Html::encode($this->title) ?></h1>

<?php switch ($updatePart) {
    case 'header':
        $subTitle = Yii::t('app', 'Offer header');
        $renderForm = '_form-header';
        $renderParams = [
            'model' => $model,
            'suppliers' => $suppliers,
            'customers' => $customers,
            'agents' => $agents,
            // 'priceLists' => $priceLists,
        ];
    break;
    case 'priceList':
        $subTitle = Yii::t('app', 'Offer price list');
        $renderForm = '_form-price-list';
        $renderParams = [
            'model' => $model,
            'priceLists' => $priceLists,
        ];
    break;
    case 'add-products':
        $subTitle = Yii::t('app', 'Select products');
        $renderForm = '_form-add-products';
        $renderParams = [
            'model' => $model,
        ];
    break;
    case 'products':
        $subTitle = Yii::t('app', 'Offer products');
        $renderForm = '_form-products';
        $renderParams = [
            'model' => $model,
        ];
    break;
    case 'footer':
        $subTitle = Yii::t('app', 'Offer footer');
        $renderForm = '_form-footer';
        $renderParams = [
            'model' => $model,
            'paymentConditions' => $paymentConditions,
            'defaultPaymentConditions' => $paymentConditions[0], //TODO da recuperare
            'returnConditions' => $returnConditions,
        ];
    break;
    default:
        $subTitle = '';
        $renderForm = '_form';
        $renderParams = [
            'model' => $model,
            'suppliers' => $suppliers,
            'customers' => $customers,
            'paymentConditions' => $paymentConditions,
            'returnConditions' => $returnConditions,
            'agents' => $agents,
        ];
    break;
}?>
    <h2><?= Html::encode($subTitle) ?></h2>
    <?= $this->render($renderForm, $renderParams) ?>

</div>
