<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
use yii\data\ActiveDataProvider;
use bitcream\pim\custom\common\models\ProductModel;

/**
 * This is the model common class for table "offer".
 */
class Offer extends base\Offer
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find();
        // ->where(['status' => 30]);
    }

    /**
     * Gets query for [[Agent]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAgent()
    {
        return $this->hasOne(Agent::className(), ['id' => 'agent_id']);
    }

    /**
     * Gets query for [[Customer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }

    /**
     * Gets query for [[OfferPriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferPriceLists()
    {
        return $this->hasMany(OfferPriceList::className(), ['offer_id' => 'id']);
    }

    /**
     * Gets query for [[OfferProducts]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferProducts()
    {
        return $this->hasMany(OfferProducts::className(), ['offer_id' => 'id'])->indexBy('id');
    }

    /**
     * Gets query for [[PaymentCondition]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPaymentCondition()
    {
        return $this->hasOne(PaymentCondition::className(), ['id' => 'payment_condition_id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['id' => 'price_list_id'])->via('offerPriceLists');
    }

    /**
     * Gets query for [[Supplier]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSupplier()
    {
        return $this->hasOne(Supplier::className(), ['id' => 'supplier_id']);
    }

    public function fields(){
        return [
            'id',
        ];
    }

    public function extraFields(){
        return [
            //offer product selection
            'selectedProducts',
            'filters',
            'header',
            'availableProducts',
            //pdf offer
            'info',
            'content' => 'pdfContent',
        ];
    }

    /**
     * Get Supplier Name
     */
    public function getSupplierName(){
        return $this->supplier->name;
    }
    /**
     * Get Customer Name
     */
    public function getCustomerName(){
        return $this->customer->name;
    }

    public function getSelectedProducts(){
        return ArrayHelper::getColumn($this->offerProducts, function ($offerProduct) {
            return $offerProduct->product->id;});
    }

    public function getFilters(){
        return [
            // [
            //     "name" => "Categorie",
            //     "key" => "category",
            //     "items" => [
            //         [
            //             "id" => 1,
            //             "slug" => "category-1",
            //             "name" => "Categoria 1",
            //         ],
            //         [
            //             "id" => 2,
            //             "slug" => "category-2",
            //             "name" => "Categoria 2",
            //         ],
            //     ],
            // ],
            [
                "name" => "Linee",
                "key" => "linea",
                "items" => [
                    [
                        "id" => "3",
                        "slug" => "line-3",
                        "name" => "Prime",
                    ],
                    [
                        "id" => "31",
                        "slug" => "line-31",
                        "name" => "Linea 31",
                    ],
                    [
                        "id" => "30",
                        "slug" => "line-30",
                        "name" => "Linea 30",
                    ],
                ],
            ],
        ];
    }

    public function getHeader(){
        return [
            [
                "name" => "codice",
                "keys" => ["codice"],
                "template" => "default" // default || description || price || percentage
            ],
            [
                "name" => "alert",
                "keys" => ["disponibilita_prodotto"],
                "template" => "alert",
            ],
            [
                "name" => "nome",
                "keys" => [
                    "title",
                    "description",
                ],
                "template" => "description",
            ],
            [
                "name" => "linea",
                "keys" => [
                    "linea",
                ],
                "template" => "linea",
            ],
        ];
    }

    public function getAvailableProducts(){
        $availableProducts = [];
        $priceList = $this->getPriceLists()->one();
        $codes = $priceList->getPriceListProductPrice()
        ->select('product_code')
        ->limit(110)
        ->column();
        $availableProductsIds = CProduct::findIdByCode($codes);
        //working
        // $availableProducts = CProduct::findAll(["id" => $availableProductsIds]);
        $availableProducts = CProduct::find()->where(["id" => $availableProductsIds])->cache(7200)->all();
        return $availableProducts;
    }

    public function getInfo()
    {
        return[
            'title' => 'title',
            'number' => $this->id,
            'data' => $this->start_date,
            'salesAgent' => $this->agent,
            'customer' => [
                'name' => $this->customer->business_name,
                'address' => $this->customer->fullAddress,
                'person' => $this->your_kind_attention,
            ],
            'supplier' => $this->supplier,
            'saleConditions' => $this->supplier->saleConditions,
        ];
    }

    public function getPdfContent()
    {
        return[
            'lines' => $this->pdfContentLines,
            'lineKey' => 'product.line_id',
            'header' => $this->supplier->pdfHeader,
            'categories' => $this->pdfContentCategories,
        ];
    }

    public function getPdfContentLines()
    {
        $lineProductModelSlug = $this->supplier->getLineProductModelSlug();
        if(!$lineProductModelSlug) return [];
        $lineProductModel = ProductModel::findOne(['slug' => $lineProductModelSlug]);
        $pdfContentLines = [];
        foreach ($lineProductModel->products as $product) {
            $line = CProduct::findOne($product->id);
            $pdfContentLines[] = [
                'id' => $line->id,
                "name" => $line->title,
                "color" => $line->colore,
                "colorMode" => $line->colormodeText,
                // "colorMode" => "cell", //cell || row
                "description" => $line->description,
            ];
        }

        return $pdfContentLines;
    }

    public function getPdfContentHeader()
    {
        return $this->supplier->getPdfHeader();
    }

    public function getPdfContentCategories()
    {
        $contentCategories = [];
        foreach($this->supplier->categories as $category){
            $CategoryChildProducts = CProduct::findSelectedChildProducts($category->id, $this->productsIds);
            if(empty($CategoryChildProducts)) continue;
            $products = [];
            foreach ($CategoryChildProducts as $product) {
                $products[] = [
                    'product' => $product,
                    'offerData' => $this->getOfferProducts()->where(['product_code'=>$product->codice])->one(),
                ];
            }

            $contentCategories[] = [
                'name' => $category->title,
                // 'note' => $category->short_title,
                'description' => $category->description,
                'products' => $products,
            ];
            // break;
        }
        return $contentCategories;
        // return $this->supplier->categories;
        // [
        //     [
        //         "name" => "Linea Bagno",
        //         "note" => "",
        //         "description" => "molto bella",
        //         'products' => [
        //             'code' => '123',
        //             "name" => "V Trend",
        //             "note" => "Nota del prodotto",
        //             "line" => 1,
        //             "rawMaterial" => "Pura Cell.",
        //             "processing" => "Microinc.",
        //             "layers" => "2",
        //             "format" => "21,5x21 cm",
        //             "piecesPerPackage" => 210,
        //             "packagesPerBox" => 15,
        //             "boxesPerPallet" => 40,
        //             "boxesPerLayer"=> 10,
        //             "prices" => [
        //               "list" => 23.30,
        //               "boxGross" => 23.00,
        //               "boxNet" => 21.00,
        //             ],
        //             "discounts" => [
        //               "sc-1" => 0.055,
        //               "sc-2" => 0.055,
        //               "sc-3" => null,
        //               "sc-4" => null,
        //               "sc-5" => null,
        //               "sc-6" => null,
        //               "boxPerPallet" => 0.01,
        //             ],
        //         ],
        //     ],
        // ];
    }

    // if(!empty($model->payment_condition_id)){
    //     CustomerSupplier::CreateOrUpdate(
    //         $model->customer_id,
    //         $model->supplier_id,
    //         ['payment_condition_id'=>$model->payment_condition_id]
    //     );
    // }

    public function pullFromCustomerSupplier(Array $fields){
        // $fields = ['payment_condition_id'=>'payment_condition_id']
        $customerSupplier = $this->customerSupplier;
        if(!empty($customerSupplier)){
            foreach ($fields as $key => $value) {
                if(isset($customerSupplier->$key)){
                    $this->$value = $customerSupplier->$key;
                }
            }
            $this->save();
        }

    }

    public function pushToCustomerSupplier(Array $fields){
        // $fields = ['payment_condition_id'=>'payment_condition_id']
        // $customerSupplier = $this->customerSupplier;
        $params = [];

        foreach ($fields as $key => $value) {
            if(isset($this->$value) && !empty($this->$value)){
                $params[$key] = $this->$value;
            }
        }

        if(!empty($params)&& $this->customer_id && $this->supplier_id){
            CustomerSupplier::CreateOrUpdate($this->customer_id,$this->supplier_id,$params);
        }

    }

    public function getCustomerSupplier(){
        return CustomerSupplier::find()
        ->where([
            'customer_id' => $this->customer_id,
            'supplier_id' => $this->supplier_id,
        ])->one();
    }

    public function getPriceListsIds()
    {
        return $this->getPriceLists()->select('id')->column();
    }

    public function setPriceListsIds(array $priceListIds)
    {
        OfferPriceList::deleteAll(['offer_id'=>$this->id]);
        foreach ($priceListIds as $priceListId) {
            $this->link('priceLists', Customer::findOne($priceListId));
        }
    }

    public function getProductsIds()
    {
        return array_map(function($id){return (int)$id;},CProduct::findIdByCode($this->getProductsCodes())) ;
    }

    public function getProductsCodes()
    {
        return $this->getOfferProducts()->select('product_code')->column();
    }

    public function setProductsCodes(array $productsCodes)
    {
        OfferProducts::deleteAll(['offer_id'=>$this->id]);
        $errors = [];
        foreach ($productsCodes as $productsCode) {
            $offerProduct = new OfferProducts();
            $offerProduct->offer_id = $this->id;
            $offerProduct->product_code = $productsCode;
            if(!($offerProduct->save())){
                 $errors[] = [
                    'productsCode' => $productsCode,
                    'response_errors' => $offerProduct->errors,
            ];}
        }
        return (!empty($errors))?$errors:true;
    }

    public function getProductsDataProvider(){
        return new ActiveDataProvider([
            'query' => $this->getOfferProducts(),
        ]);
    }

    public function getPdfLink()
    {
        return Yii::$app->params['OfferPdfurl'].$this->id.'?print=1';
    }

    public function checkPriceLists()
    {
        foreach ($this->priceLists as $priceList) {
            $priceList->importCsv();
            if($priceList->getPriceListProductPrice()->count()){
                return true;
                // Yii::$app->session->setFlash('success', "Your message to display.");
            }
        }
        return false;
    }
}
