<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
/**
 * This is the model common class for table "price_list".
 */
class PriceList extends base\PriceList
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'files' => [
                'class' => 'floor12\files\components\FileBehaviour',
                'attributes' => [
                    'csv',
                ],
            ],
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
            ['csv', 'file', 'maxFiles' => 1],

        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'csv' => Yii::t('app', 'Csv file'),
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find()
        // ->where(['status' => 30])
        ;
    }

    public function getCustomers_ids()
    {
        return $this->getCustomers()->select('id')->column();
    }

    public function setCustomers_ids(array $customers_ids)
    {
        PriceListCustomer::deleteAll(['price_list_id'=>$this->id]);
        foreach ($customers_ids as $customer_id) {
            $this->link('customers', Customer::findOne($customer_id));
        }
    }

    public function importCsv(){
        if(empty($this->csv)) return false;
        $modelIds = [];
        $errors = [];

        PriceListProductPrice::deleteAll(['price_list_id'=>$this->id]);
        $csvRows = file($this->csv->rootPath, FILE_IGNORE_NEW_LINES);
        $dataRows = array_map(
            function($value){return explode(";", $value);},
            $csvRows
        );

        foreach ($dataRows as $key => $dataRow) {
            if($key==0) continue;
            $product_code = $dataRow[0];
            $price = (float)$dataRow[1];

            $model = new PriceListProductPrice();
            $model->price_list_id = $this->id;
            $model->product_code = $product_code;
            $model->price = $price;
            if(!($model->save())){
                $errors[]= [
                    'csv line' => $key+1,
                    'product_code' => $product_code,
                    'price' => $price,
                ];
                continue;
            }
                $modelIds[]=$model->id;
        }
        $linesImported = count($modelIds);
        $linesToImport = count($dataRows)-1;
        // echo 'righe: '.$linesToImport.', importate: '.$linesImported;

        return[
            'linesToImport' => $linesToImport,
            'linesImported' => $linesImported,
            'modelIds' => $modelIds,
            'errors' => $errors,
        ];
    }

}
