<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%price_list_product_price}}".
 *
 * @property int $id
 * @property string $product_code
 * @property float $price
 * @property int $price_list_id
 *
 * @property PriceList $priceList
 */
class PriceListProductPrice extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%price_list_product_price}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_code', 'price', 'price_list_id'], 'required'],
            [['price'], 'number'],
            [['price_list_id'], 'integer'],
            [['product_code'], 'string', 'max' => 20],
            [['price_list_id'], 'exist', 'skipOnError' => true, 'targetClass' => PriceList::className(), 'targetAttribute' => ['price_list_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'product_code' => Yii::t('app', 'Product Code'),
            'price' => Yii::t('app', 'Price'),
            'price_list_id' => Yii::t('app', 'Price List ID'),
        ];
    }

    /**
     * Gets query for [[PriceList]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceList()
    {
        return $this->hasOne(PriceList::className(), ['id' => 'price_list_id']);
    }
}
