<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%customer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%customer_category}}`
 * - `{{%customer_association}}`
 */
class M221009230756AddCustomerCategoryIdColumnCustomerAssociationIdColumnToCustomerTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%customer}}', 'customer_category_id', $this->integer()->null());
        $this->addColumn('{{%customer}}', 'customer_association_id', $this->integer()->null());

        // creates index for column `customer_category_id`
        $this->createIndex(
            '{{%idx-customer-customer_category_id}}',
            '{{%customer}}',
            'customer_category_id'
        );

        // add foreign key for table `{{%customer_category}}`
        $this->addForeignKey(
            '{{%fk-customer-customer_category_id}}',
            '{{%customer}}',
            'customer_category_id',
            '{{%customer_category}}',
            'id',
            'CASCADE'
        );

        // creates index for column `customer_association_id`
        $this->createIndex(
            '{{%idx-customer-customer_association_id}}',
            '{{%customer}}',
            'customer_association_id'
        );

        // add foreign key for table `{{%customer_association}}`
        $this->addForeignKey(
            '{{%fk-customer-customer_association_id}}',
            '{{%customer}}',
            'customer_association_id',
            '{{%customer_association}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%customer_category}}`
        $this->dropForeignKey(
            '{{%fk-customer-customer_category_id}}',
            '{{%customer}}'
        );

        // drops index for column `customer_category_id`
        $this->dropIndex(
            '{{%idx-customer-customer_category_id}}',
            '{{%customer}}'
        );

        // drops foreign key for table `{{%customer_association}}`
        $this->dropForeignKey(
            '{{%fk-customer-customer_association_id}}',
            '{{%customer}}'
        );

        // drops index for column `customer_association_id`
        $this->dropIndex(
            '{{%idx-customer-customer_association_id}}',
            '{{%customer}}'
        );

        $this->dropColumn('{{%customer}}', 'customer_category_id');
        $this->dropColumn('{{%customer}}', 'customer_association_id');
    }
}
