<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%customer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%agent}}`
 */
class M221012142823AddAgentIdColumnToCustomerTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%customer}}', 'agent_id', $this->integer()->defaultValue(1)->notNull());

        // creates index for column `agent_id`
        $this->createIndex(
            '{{%idx-customer-agent_id}}',
            '{{%customer}}',
            'agent_id'
        );

        // add foreign key for table `{{%agent}}`
        $this->addForeignKey(
            '{{%fk-customer-agent_id}}',
            '{{%customer}}',
            'agent_id',
            '{{%agent}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%agent}}`
        $this->dropForeignKey(
            '{{%fk-customer-agent_id}}',
            '{{%customer}}'
        );

        // drops index for column `agent_id`
        $this->dropIndex(
            '{{%idx-customer-agent_id}}',
            '{{%customer}}'
        );

        $this->dropColumn('{{%customer}}', 'agent_id');
    }
}
