<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles dropping columns from table `{{%price_list}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%customer}}`
 */
class M221013075219DropCustomerIdColumnFromPriceListTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%customer}}`
        $this->dropForeignKey(
            '{{%fk-price_list-customer_id}}',
            '{{%price_list}}'
        );

        // drops index for column `customer_id`
        $this->dropIndex(
            '{{%idx-price_list-customer_id}}',
            '{{%price_list}}'
        );

        $this->dropColumn('{{%price_list}}', 'customer_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%price_list}}', 'customer_id', $this->integer()->null());

        // creates index for column `customer_id`
        $this->createIndex(
            '{{%idx-price_list-customer_id}}',
            '{{%price_list}}',
            'customer_id'
        );

        // add foreign key for table `{{%customer}}`
        $this->addForeignKey(
            '{{%fk-price_list-customer_id}}',
            '{{%price_list}}',
            'customer_id',
            '{{%customer}}',
            'id',
            'CASCADE'
        );
    }
}
