<?php

namespace Bitcream\Corradi\Custom\backend\controllers;

use Yii;
use Bitcream\Corradi\Custom\common\models\CustomerSupplier;
use Bitcream\Corradi\Custom\backend\models\CustomerSupplierSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * CustomerSupplierController implements the CRUD actions for CustomerSupplier model.
 */
class CustomerSupplierController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all CustomerSupplier models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CustomerSupplierSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single CustomerSupplier model.
     * @param integer $customer_id
     * @param integer $supplier_id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($customer_id, $supplier_id)
    {
        return $this->render('view', [
            'model' => $this->findModel($customer_id, $supplier_id),
        ]);
    }

    /**
     * Creates a new CustomerSupplier model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new CustomerSupplier();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing CustomerSupplier model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $customer_id
     * @param integer $supplier_id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($customer_id, $supplier_id)
    {
        $model = $this->findModel($customer_id, $supplier_id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing CustomerSupplier model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $customer_id
     * @param integer $supplier_id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($customer_id, $supplier_id)
    {
        $this->findModel($customer_id, $supplier_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the CustomerSupplier model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $customer_id
     * @param integer $supplier_id
     * @return CustomerSupplier the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($customer_id, $supplier_id)
    {
        if (($model = CustomerSupplier::findOne(['customer_id' => $customer_id, 'supplier_id' => $supplier_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
