<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;
use yii\helpers\ArrayHelper;

?>
<div class="price-list-datatable">
    <?=        Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'price-list-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Supplier'),
                    'format'=>'raw',
                    'value' => 'supplier.business_name',
                ],
                ['attribute'=>Yii::t('app', 'Customers'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return implode(', ', ArrayHelper::getColumn($data->customers, function ($customer) {
                        return $customer['business_name'];}));}
                ],
                'is_active:boolean',
                ['attribute'=>Yii::t('app', 'Update products'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a('Update', [Yii::$app->controller->id.'/import','id'=>$data->id],['class' => 'btn btn-primary']);}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>