<?php

namespace Bitcream\Corradi\Custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use Emberware\Evidia\Application\CreateUpdateStatus\StatusBehaviors;
use Emberware\Evidia\Application\CreateUpdateStatus\CreateUpdateBehaviors;
/**
 * This is the model common class for table "offer_products".
 */
class OfferProducts extends base\OfferProducts
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
       ]);
    }

    /**
    * {@inheritdoc}
    */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [
        ]);
    }

    /**
    * {@inheritdoc}
    */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
        ]);
    }

    /**
    * Rewrite function find for get only active element
    */
    public static function find(){
        return parent::find()
        // ->where(['status' => 30])
        ;
    }


    /**
     * Gets query for [[Offer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        return CProduct::findByCode($this->product_code);
        // return $this->hasOne(CProduct::class, ['codice' => 'product_code']);
    }

    public function fields(){
        return [
            'discount_1' => 'discount1Per',
            'discount_2' => 'discount2Per',
            'discount_3' => 'discount3Per',
            'discount_4' => 'discount4Per',
            // 'discount_5' => 'discount5Per',
            // 'discount_6' => 'discount6Per',
            'net_price',
            'merchandise_discount',
            'notes',
        ];
    }

    public function percentage(float|null $number)
    {
        return $number/100;
    }

    public function getDiscount1Per()
    {
        return $this->percentage($this->discount_1);
    }

    public function getDiscount2Per()
    {
        return $this->percentage($this->dscount_2);
    }

    public function getDiscount3Per()
    {
        return $this->percentage($this->discount_3);
    }

    public function getDiscount4Per()
    {
        return $this->percentage($this->discount_4);
    }

    public function getDiscount5Per()
    {
        return $this->percentage($this->discount_5);
    }

    public function getDiscount6Per()
    {
        return $this->percentage($this->discount_6);
    }


}
