<?php

namespace Bitcream\Corradi\Custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%offer}}".
 *
 * @property int $id
 * @property int|null $supplier_id
 * @property string|null $start_date
 * @property string|null $payment_notes
 * @property string $created_at
 * @property string|null $end_date
 * @property string|null $tail_lift_notes
 * @property int|null $payment_condition_id
 * @property string|null $delivery_terms_notes
 * @property int|null $agent_id
 * @property string|null $your_kind_attention
 * @property int|null $customer_id
 *
 * @property Agent $agent
 * @property Customer $customer
 * @property OfferPriceList[] $offerPriceLists
 * @property OfferProducts[] $offerProducts
 * @property PaymentCondition $paymentCondition
 * @property PriceList[] $priceLists
 * @property Supplier $supplier
 */
class Offer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%offer}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['supplier_id', 'payment_condition_id', 'agent_id', 'customer_id'], 'integer'],
            [['payment_notes', 'tail_lift_notes', 'delivery_terms_notes'], 'string'],
            [['created_at', 'end_date'], 'safe'],
            [['start_date'], 'string', 'max' => 20],
            [['your_kind_attention'], 'string', 'max' => 255],
            [['agent_id'], 'exist', 'skipOnError' => true, 'targetClass' => Agent::className(), 'targetAttribute' => ['agent_id' => 'id']],
            [['customer_id'], 'exist', 'skipOnError' => true, 'targetClass' => Customer::className(), 'targetAttribute' => ['customer_id' => 'id']],
            [['payment_condition_id'], 'exist', 'skipOnError' => true, 'targetClass' => PaymentCondition::className(), 'targetAttribute' => ['payment_condition_id' => 'id']],
            [['supplier_id'], 'exist', 'skipOnError' => true, 'targetClass' => Supplier::className(), 'targetAttribute' => ['supplier_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'supplier_id' => Yii::t('app', 'Supplier ID'),
            'start_date' => Yii::t('app', 'Start Date'),
            'payment_notes' => Yii::t('app', 'Payment Notes'),
            'created_at' => Yii::t('app', 'Created At'),
            'end_date' => Yii::t('app', 'End Date'),
            'tail_lift_notes' => Yii::t('app', 'Tail Lift Notes'),
            'payment_condition_id' => Yii::t('app', 'Payment Condition ID'),
            'delivery_terms_notes' => Yii::t('app', 'Delivery Terms Notes'),
            'agent_id' => Yii::t('app', 'Agent ID'),
            'your_kind_attention' => Yii::t('app', 'Your Kind Attention'),
            'customer_id' => Yii::t('app', 'Customer ID'),
        ];
    }

    /**
     * Gets query for [[Agent]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAgent()
    {
        return $this->hasOne(Agent::className(), ['id' => 'agent_id']);
    }

    /**
     * Gets query for [[Customer]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }

    /**
     * Gets query for [[OfferPriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferPriceLists()
    {
        return $this->hasMany(OfferPriceList::className(), ['offer_id' => 'id']);
    }

    /**
     * Gets query for [[OfferProducts]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOfferProducts()
    {
        return $this->hasMany(OfferProducts::className(), ['offer_id' => 'id']);
    }

    /**
     * Gets query for [[PaymentCondition]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPaymentCondition()
    {
        return $this->hasOne(PaymentCondition::className(), ['id' => 'payment_condition_id']);
    }

    /**
     * Gets query for [[PriceLists]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPriceLists()
    {
        return $this->hasMany(PriceList::className(), ['id' => 'price_list_id'])->via('offerPriceLists');
    }

    /**
     * Gets query for [[Supplier]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSupplier()
    {
        return $this->hasOne(Supplier::className(), ['id' => 'supplier_id']);
    }
}
