<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%offer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%return_condition}}`
 * - `{{%payment_condition}}`
 */
class M221007020151AddReturnConditionIdColumnPaymentConditionIdColumntoOfferTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%offer}}', 'return_condition_id', $this->integer()->null());
        $this->addColumn('{{%offer}}', 'payment_condition_id', $this->integer()->null());

        // creates index for column `return_condition_id`
        $this->createIndex(
            '{{%idx-offer-return_condition_id}}',
            '{{%offer}}',
            'return_condition_id'
        );

        // add foreign key for table `{{%return_condition}}`
        $this->addForeignKey(
            '{{%fk-offer-return_condition_id}}',
            '{{%offer}}',
            'return_condition_id',
            '{{%return_condition}}',
            'id',
            'CASCADE'
        );

        // creates index for column `payment_condition_id`
        $this->createIndex(
            '{{%idx-offer-payment_condition_id}}',
            '{{%offer}}',
            'payment_condition_id'
        );

        // add foreign key for table `{{%payment_condition}}`
        $this->addForeignKey(
            '{{%fk-offer-payment_condition_id}}',
            '{{%offer}}',
            'payment_condition_id',
            '{{%payment_condition}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%return_condition}}`
        $this->dropForeignKey(
            '{{%fk-offer-return_condition_id}}',
            '{{%offer}}'
        );

        // drops index for column `return_condition_id`
        $this->dropIndex(
            '{{%idx-offer-return_condition_id}}',
            '{{%offer}}'
        );

        // drops foreign key for table `{{%payment_condition}}`
        $this->dropForeignKey(
            '{{%fk-offer-payment_condition_id}}',
            '{{%offer}}'
        );

        // drops index for column `payment_condition_id`
        $this->dropIndex(
            '{{%idx-offer-payment_condition_id}}',
            '{{%offer}}'
        );

        $this->dropColumn('{{%offer}}', 'return_condition_id');
        $this->dropColumn('{{%offer}}', 'payment_condition_id');
    }
}
