<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%offer}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%agent}}`
 */
class M221010085221AddAgentIdColumnToOfferTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%offer}}', 'agent_id', $this->integer()->null());

        // creates index for column `agent_id`
        $this->createIndex(
            '{{%idx-offer-agent_id}}',
            '{{%offer}}',
            'agent_id'
        );

        // add foreign key for table `{{%agent}}`
        $this->addForeignKey(
            '{{%fk-offer-agent_id}}',
            '{{%offer}}',
            'agent_id',
            '{{%agent}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%agent}}`
        $this->dropForeignKey(
            '{{%fk-offer-agent_id}}',
            '{{%offer}}'
        );

        // drops index for column `agent_id`
        $this->dropIndex(
            '{{%idx-offer-agent_id}}',
            '{{%offer}}'
        );

        $this->dropColumn('{{%offer}}', 'agent_id');
    }
}
