<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Field\Date\Date;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Offer */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="offer-form">

    <?php $form = ActiveForm::begin(); ?>
                <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'supplier_id')->widget(Select2::class, [
                'name' => 'supplier_id',
                'class' => 'form-group supplier_id form-control',
                'value' => ArrayHelper::map($suppliers, 'id', function ($supplier) {
                    return $supplier['business_name'];
                }),
                'id' => 'supplier_id',
                'data' => ArrayHelper::map($suppliers, 'id', function ($supplier) {
                    return $supplier['business_name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select supplier')]
            ])->label(Yii::t('app', 'Supplier'));?>
           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'customer_id')->widget(Select2::class, [
                'name' => 'customer_id',
                'class' => 'form-group customer_id form-control',
                'value' => ArrayHelper::map($customers, 'id', function ($customer) {
                    return $customer['business_name'];
                }),
                'id' => 'customer_id',
                'data' => ArrayHelper::map($customers, 'id', function ($customer) {
                    return $customer['business_name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select customer')]
            ])->label(Yii::t('app', 'Customer'));?>

           </div>
        </div>

        <div class='row'>
          <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'your_kind_attention')->textInput(['maxlength' => true]) ?>
          </div>
       </div>

        <div class='row'>
          <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'agent_id')->widget(Select2::class, [
                'name' => 'agent_id',
                'class' => 'form-group agent_id form-control',
                'value' => ArrayHelper::map($agents, 'id', function ($agent) {
                    return $agent['fullName'];
                }),
                'id' => 'agent_id',
                'data' => ArrayHelper::map($agents, 'id', function ($agent) {
                    return $agent['fullName'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select Agent')]
            ])->label(Yii::t('app', 'Agent'));?>
          </div>
       </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'start_date')->widget(Date::class) ?>

           </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'end_date')->widget(Date::class) ?>

            </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'delivery_terms_notes')->textarea(['rows' => 6]) ?>
           </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'tail_lift_notes')->textarea(['rows' => 6]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'payment_condition_id')->widget(Select2::class, [
                'name' => 'payment_condition_id',
                'class' => 'form-group payment_condition_id form-control',
                'value' => ArrayHelper::map($paymentConditions, 'id', function ($paymentCondition) {
                    return $paymentCondition['name'];
                }),
                'id' => 'payment_condition_id',
                'data' => ArrayHelper::map($paymentConditions, 'id', function ($paymentCondition) {
                    return $paymentCondition['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select payment conditions')]
            ])->label(Yii::t('app', 'Payment conditions'));?>


            </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'payment_notes')->textarea(['rows' => 6]) ?>

           </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
