<?php

namespace Bitcream\Corradi\Custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%offer_products}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%offer}}`
 */
class M221014083631CreateOfferProductsTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%offer_products}}', [
            'id' => $this->primaryKey(),
            'offer_id' => $this->integer()->notNull(),
            'product_code' => $this->string(20)->notNull(),
            'show_avalibility' => $this->boolean()->defaultValue(0),
            'discount_1' => $this->float()->null(),
            'dscount_2' => $this->float()->null(),
            'discount_3' => $this->float()->null(),
            'discount_4' => $this->float()->null(),
            'discount_5' => $this->float()->null(),
            'net_price' => $this->float()->null(),
            'merchandise_discount' => $this->float()->null(),
            'notes' => $this->string(255)->null(),
        ]);

        // creates index for column `offer_id`
        $this->createIndex(
            '{{%idx-offer_products-offer_id}}',
            '{{%offer_products}}',
            'offer_id'
        );

        // add foreign key for table `{{%offer}}`
        $this->addForeignKey(
            '{{%fk-offer_products-offer_id}}',
            '{{%offer_products}}',
            'offer_id',
            '{{%offer}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%offer}}`
        $this->dropForeignKey(
            '{{%fk-offer_products-offer_id}}',
            '{{%offer_products}}'
        );

        // drops index for column `offer_id`
        $this->dropIndex(
            '{{%idx-offer_products-offer_id}}',
            '{{%offer_products}}'
        );

        $this->dropTable('{{%offer_products}}');
    }
}
