<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<div class="agent-datatable">
    <?=        Datatable::widget([
            'dataProvider' => $dataProvider,
            'id' => 'agent-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Full Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->fullName, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                'email',
                'phone_number_1',
                [
                    'attribute'=>Yii::t('app', 'Edit'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a(Yii::t('app', 'Edit'), [Yii::$app->controller->id.'/update','id'=>$data->id], ['class' => 'btn btn-primary']);},
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>