<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<h3><?= Html::encode(Yii::t('app', 'Product List')) ?></h3>

<div class="price-list-products-datatable">
    <?= Datatable::widget([
            'dataProvider' => $model->productsDataProvider,
            'id' => 'price-list-products-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'product_code',
                'price',
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>