<?php

namespace Bitcream\Corradi\Custom\backend\controllers;

use Yii;
use Bitcream\Corradi\Custom\common\models\PriceList;
use Bitcream\Corradi\Custom\backend\models\PriceListSearch;
use Bitcream\Corradi\Custom\common\models\Customer;
use Bitcream\Corradi\Custom\common\models\Supplier;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * PriceListController implements the CRUD actions for PriceList model.
 */
class PriceListController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all PriceList models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new PriceListSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single PriceList model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $model = $this->findModel($id);

        // $importResult = $model->importCsv();
        return $this->render('view', [
            'model' => $model,
            // 'importResult' => $importResult,
        ]);
    }

    /**
     * Creates a new PriceList model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new PriceList();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
                $model->setCustomers_ids(Yii::$app->request->post('PriceList')['customers_ids']);
            $model->importCsv();
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'suppliers' => Supplier::find()->all(),
            'customers' => Customer::find()->all(),
        ]);
    }

    /**
     * Updates an existing PriceList model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
                $model->setCustomers_ids(Yii::$app->request->post('PriceList')['customers_ids']);
            $model->importCsv();
            return $this->redirect(['view', 'id'=>$model->id]);
        }

        return $this->render('update', [
            'model' => $model,
            'suppliers' => Supplier::find()->all(),
            'customers' => Customer::find()->all(),
        ]);
    }

    public function actionImport($id){
        $model = $this->findModel($id);
        $model->importCsv();
        return $this->redirect(['index']);
    }

    /**
     * Deletes an existing PriceList model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the PriceList model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PriceList the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PriceList::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
