<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model Bitcream\Corradi\Custom\common\models\Customer */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-form">

    <?php $form = ActiveForm::begin(); ?>
                <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'business_name')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'vat_id')->textInput(['maxlength' => true]) ?>

           </div>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'fiscal_code')->textInput(['maxlength' => true]) ?>

           </div>
        </div>


        <div class='row'>
          <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'bank_account_address')->textInput(['maxlength' => true]) ?>
          </div>
       </div>
       <div class='row'>
          <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'pec')->textInput(['maxlength' => true]) ?>
          </div>
          <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'sdi_code')->textInput(['maxlength' => true]) ?>
          </div>
       </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'website_url')->textInput(['maxlength' => true]) ?>

           </div>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <h3><?= Html::encode(Yii::t('app', 'Registered office')) ?></h3>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'address')->textInput(['maxlength' => true]) ?>

           </div>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'postal_code')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'city')->textInput(['maxlength' => true]) ?>

           </div>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'province')->textInput(['maxlength' => true]) ?>

           </div>
        </div>

        <h3><?= Html::encode(Yii::t('app', 'Business management')) ?></h3>

       <div class='row'>
          <div class='col-md-6 col-xs-12'>
              <?= $form->field($model, 'agent_id')->widget(Select2::class, [
                'name' => 'agent_id',
                'class' => 'form-group agent_id form-control',
                'value' => ArrayHelper::map($agents, 'id', function ($agent) {
                    return $agent['name'];
                }),
                'id' => 'agent_id',
                'data' => ArrayHelper::map($agents, 'id', function ($agent) {
                    return $agent['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select Agent')]
            ])->label(Yii::t('app', 'Agent'));?>

          </div>
       </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'customer_category_id')->widget(Select2::class, [
                'name' => 'customer_category_id',
                'class' => 'form-group customer_category_id form-control',
                'value' => ArrayHelper::map($customerCategories, 'id', function ($customerCategory) {
                    return $customerCategory['name'];
                }),
                'id' => 'customer_category_id',
                'data' => ArrayHelper::map($customerCategories, 'id', function ($customerCategory) {
                    return $customerCategory['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select Category')]
            ])->label(Yii::t('app', 'Category'));?>
           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'customer_association_id')->widget(Select2::class, [
                'name' => 'customer_association_id',
                'class' => 'form-group customer_association_id form-control',
                'value' => ArrayHelper::map($customerAssociations, 'id', function ($customerAssociation) {
                    return $customerAssociation['name'];
                }),
                'id' => 'customer_association_id',
                'data' => ArrayHelper::map($customerAssociations, 'id', function ($customerAssociation) {
                    return $customerAssociation['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select Association')]
            ])->label(Yii::t('app', 'Association'));?>

           </div>
        </div>

        <div class='row'>
           <div class='col-md-6 col-xs-12'>
               <?= $form->field($model, 'customer_channel_id')->widget(Select2::class, [
                'name' => 'customer_channel_id',
                'class' => 'form-group customer_channel_id form-control',
                'value' => ArrayHelper::map($customerChannels, 'id', function ($customerChannel) {
                    return $customerChannel['name'];
                }),
                'id' => 'customer_channel_id',
                'data' => ArrayHelper::map($customerChannels, 'id', function ($customerChannel) {
                    return $customerChannel['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select Channel')]
            ])->label(Yii::t('app', 'Channel'));?>

           </div>
        </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
