<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

$attributesPimProducts = [];
if (!empty($model->getOfferProducts()->one())) {
    // echo 'product: '.json_encode($model->getOfferProducts()->one()->product->id);
    // echo 'product->pz_per_confezione: '.json_encode($model->getOfferProducts()->one()->product->pz_per_confezione);
    if ($model->getOfferProducts()->one()->product->pz_per_confezione) {
        $attributesPimProducts[]= [
            'label' => Yii::t('app', 'pz_per_confezione'),
            'value' => function ($data) {
                return $data->product->pz_per_confezione;
            },
            'format' => 'text',
        ];
    }
    if ($model->getOfferProducts()->one()->product->confezioni_per_collo) {
        $attributesPimProducts[]=[
            'label' => Yii::t('app', 'confezioni_per_collo'),
            'value' => function ($data) {
                return $data->product->confezioni_per_collo;
            },
        ];
    }
    if ($model->getOfferProducts()->one()->product->colli_per_pallet) {
        $attributesPimProducts[]= [
            'label' => Yii::t('app', 'colli_per_pallet'),
            'value' => function ($data) {
                return $data->product->colli_per_pallet;
            },
        ];
    }
    if ($model->getOfferProducts()->one()->product->colli_per_strato) {
        $attributesPimProducts[]= [
            'label' => Yii::t('app', 'colli_per_strato'),
            'value' => function ($data) {
                return $data->product->colli_per_strato;
            },
        ];
    }
}

$attributesOfferProducts = [
    'product_code',
    [
        'attribute'=>Yii::t('app', 'Title'),
        'format'=>'raw',
        'value' => function($data)
        {return ($data->product?->title?:"");},
    ],
];
$attributesOfferProductsToInput  = [
    [
        'attribute'=>'net_price',
        'label' => Yii::t('app', 'Price list price'),
        'format'=>'raw',
        'value' => function ($data) {
            return '€ '.number_format($data->net_price, 2, ',', ' ');
        },
    ],
    'show_avalibility:boolean',
    'discount_1',
    'dscount_2',
    'discount_3',
    'discount_4',
    // 'discount_5',
    [
        'attribute' => 'netPrice',
        'label' => Yii::t('app', 'Net price'),
        'format'=>'raw',
        'value' => function ($data) {
            return '€ '.number_format($data->netPrice, 2, ',', ' ');
        },
    ],
    'merchandise_discount',
    [
        'attribute'=>'netPriceAfterMerchandiseDiscount',
        'label' => Yii::t('app', 'Net price after merchandise discount'),
        'format'=>'raw',
        'value' => function ($data) {
            return '€ '.number_format($data->netPriceAfterMerchandiseDiscount, 2, ',', ' ');
        },

    ],
    'notes',
];
$columns = array_merge($attributesOfferProducts,$attributesPimProducts,$attributesOfferProductsToInput);


?>
<div class="offer-products-datatable">
    <?= Datatable::widget([
            'dataProvider' => $model->productsDataProvider,
            'id' => 'offer-products-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => $columns,
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>