<?php

use yii\helpers\Html;
use Emberware\Evidia\Toolkit\Model\Datatable;

?>
<h3><?= Html::encode(Yii::t('app', 'Product List')) ?></h3>

<div class="price-list-products-datatable">
    <?= Datatable::widget([
            'dataProvider' => $model->productsDataProvider,
            'id' => 'price-list-products-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'product_code',
                'price',
                [
                    'attribute'=>Yii::t('app', 'Edit'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a(Yii::t('app', 'Edit'), ['price-list-product-price/update','id'=>$data->id], ['class' => 'btn btn-primary']);},
                ],
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>